package com.pushpole.sdk.collection.tasks;

import android.content.Context;

import com.pushpole.sdk.network.SendManager;
import com.pushpole.sdk.task.PushPoleTask;
import com.pushpole.sdk.task.options.DefaultOptions;
import com.pushpole.sdk.task.options.SingletonTask;
import com.pushpole.sdk.util.ListPack;
import com.pushpole.sdk.util.Pack;

/**
 * Created by vahid on 7/14/16.
 * Collection task mainly for collecting user data
 * All these tasks are periodic
 */
@SingletonTask
@DefaultOptions(period = 15 * 60 * 1000, persisted = true) //default is 15 minutes
public abstract class CollectionTask implements PushPoleTask {
    /**
     * Send upstream or save to DB, based on immediate status.
     *
     * @param p
     * @param msgTypeCode
     */
    protected void processResult(Context context, Pack p, String msgTypeCode) {
        SendManager.getInstance(context).send(msgTypeCode, p);
    }

    protected void processResult(Context context, ListPack listPack, String msgTypeCode) {
        SendManager.getInstance(context).send(msgTypeCode, listPack);
    }
}
