package com.pushpole.sdk.action.actions;

import android.content.Intent;

import com.pushpole.sdk.Constants;
import com.pushpole.sdk.action.Action;
import com.pushpole.sdk.action.ActionFactory;
import com.pushpole.sdk.action.ActionType;
import com.pushpole.sdk.util.Pack;

/**
 * Open URL Action; opens a specific url.
 */
public class UrlAction extends IntentAction {

    /**
     * return type
     *
     * @return {@code ActionType.URL}
     */
    @Override
    public ActionType getActionType() {
        return ActionType.URL;
    }

    /**
     * serialize to {@link Pack}
     *
     * @return
     */
    @Override
    public Pack toPack() {
        Pack pack = super.toPack();
        pack.putString(Constants.getVal(Constants.F_URL), mData);
        return pack;
    }

    /**
     * Factory class to generate {@link UrlAction} instance
     */
    public static class Factory extends ActionFactory {
        /**
         * generate {@link UrlAction} instance
         *
         * @param data the data to create the {@code Action} with given as a {@link Pack}
         * @return {@link UrlAction} instance
         */
        @Override
        public Action buildAction(Pack data) {
            UrlAction action = new UrlAction();
            action.mData = data.getString(Constants.getVal(Constants.F_URL), "");
            action.mAction = Intent.ACTION_VIEW;//TODO: read it from pack, also read package name to check availability of that marke
            String packageName = data.getString(Constants.getVal(Constants.MARKET_PACKAGE_NAME));
            if(packageName != null && !packageName.isEmpty())
                action.mPackage = packageName;
            return action;
        }
    }
}
