package com.pushpole.sdk.task.tasks;

import android.content.Context;
import android.support.annotation.NonNull;

import com.pushpole.sdk.internal.log.Logger;
import com.pushpole.sdk.network.SendManager;
import com.pushpole.sdk.task.PushPoleTask;
import com.pushpole.sdk.task.Result;
import com.pushpole.sdk.task.options.DefaultOptions;
import com.pushpole.sdk.task.options.SingletonTask;
import com.pushpole.sdk.util.Pack;

/**
 * Created by vahid on 7/14/16.
 * This class schedules sending upstreams
 */
@SingletonTask
@DefaultOptions(period = 24 * 3600 * 1000, persisted = true, network = true)
public class FlushDBTask implements PushPoleTask {

    @NonNull
    @Override
    public Result runTask(Context context, Pack taskPack) {
        Logger.debug("FlushDB task is running...");
        SendManager.getInstance(context).sendDatabaseChunks(true);
        return Result.SUCCESS;
    }
}
