package com.pushpole.sdk.message.downstream;

import com.pushpole.sdk.util.Pack;

/**
 * Created on 16-07-12, 6:02 PM.
 *
 * @author Akram Shokri
 */
public class DialogWhithoutShowingNotif extends NotificationTypesDownstreamMessage {
    private Pack mData;

    @Override
    public Type getMessageType() {
        return Type.DIALOG_NOT_SHOW_NOTIFICATION;
    }

    public static class Factory extends DownstreamMessageFactory {

        @Override
        public DownstreamMessage buildMessage(Pack data) {
            DialogWhithoutShowingNotif msg = new DialogWhithoutShowingNotif();
            populateMessage(msg, data);
            msg.mData = new Pack(data);

            return msg;
        }
    }

    public Pack getData() {
        return mData;
    }

}
