/*
 * Decompiled with CFR 0.152.
 */
package com.pusher.client.example;

import com.pusher.client.Pusher;
import com.pusher.client.PusherOptions;
import com.pusher.client.channel.PresenceChannel;
import com.pusher.client.channel.PresenceChannelEventListener;
import com.pusher.client.channel.PusherEvent;
import com.pusher.client.channel.User;
import com.pusher.client.connection.ConnectionEventListener;
import com.pusher.client.connection.ConnectionState;
import com.pusher.client.connection.ConnectionStateChange;
import com.pusher.client.util.HttpAuthorizer;
import java.util.Set;

public class PresenceChannelExampleApp {
    private String channelsKey = "FILL_ME_IN";
    private String channelName = "my-channel";
    private String eventName = "my-event";
    private String cluster = "eu";
    private String authorizationEndpoint = "http://localhost:3030/pusher/auth";
    private final PresenceChannel channel;

    public static void main(String[] args) {
        new PresenceChannelExampleApp(args);
    }

    private PresenceChannelExampleApp(String[] args) {
        switch (args.length) {
            case 4: {
                this.cluster = args[3];
            }
            case 3: {
                this.eventName = args[2];
            }
            case 2: {
                this.channelName = args[1];
            }
            case 1: {
                this.channelsKey = args[0];
            }
        }
        HttpAuthorizer authorizer = new HttpAuthorizer(this.authorizationEndpoint);
        PusherOptions options = new PusherOptions().setUseTLS(true).setCluster(this.cluster).setAuthorizer(authorizer);
        Pusher pusher = new Pusher(this.channelsKey, options);
        ConnectionEventListener connectionEventListener = new ConnectionEventListener(){

            @Override
            public void onConnectionStateChange(ConnectionStateChange change) {
                System.out.println(String.format("Connection state changed from [%s] to [%s]", new Object[]{change.getPreviousState(), change.getCurrentState()}));
            }

            @Override
            public void onError(String message, String code, Exception e) {
                System.out.println(String.format("An error was received with message [%s], code [%s], exception [%s]", message, code, e));
            }
        };
        pusher.connect(connectionEventListener, new ConnectionState[0]);
        PresenceChannelEventListener presenceChannelEventListener = new PresenceChannelEventListener(){

            @Override
            public void onSubscriptionSucceeded(String channelName) {
                System.out.println(String.format("Subscription to channel [%s] succeeded", channelName));
            }

            @Override
            public void onEvent(PusherEvent event) {
                System.out.println(String.format("Received event [%s]", event.toString()));
            }

            @Override
            public void onAuthenticationFailure(String message, Exception e) {
                System.out.println(String.format("Authentication failure due to [%s], exception was [%s]", message, e));
            }

            @Override
            public void onUsersInformationReceived(String channelName, Set<User> users) {
                System.out.println("Received user information");
                PresenceChannelExampleApp.this.printCurrentlySubscribedUsers();
            }

            @Override
            public void userSubscribed(String channelName, User user) {
                System.out.println(String.format("A new user has joined channel [%s]: %s", channelName, user.toString()));
                PresenceChannelExampleApp.this.printCurrentlySubscribedUsers();
            }

            @Override
            public void userUnsubscribed(String channelName, User user) {
                System.out.println(String.format("A user has left channel [%s]: %s", channelName, user));
                PresenceChannelExampleApp.this.printCurrentlySubscribedUsers();
            }
        };
        this.channel = pusher.subscribePresence(this.channelName, presenceChannelEventListener, this.eventName);
        while (true) {
            try {
                while (true) {
                    Thread.sleep(1000L);
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    private void printCurrentlySubscribedUsers() {
        StringBuilder sb = new StringBuilder("Users now subscribed to the channel:");
        for (User user : this.channel.getUsers()) {
            sb.append("\n\t");
            sb.append(user.toString());
            if (!user.equals(this.channel.getMe())) continue;
            sb.append(" (me)");
        }
        System.out.println(sb.toString());
    }
}

