/*
 * Decompiled with CFR 0.152.
 */
package com.pusher.client;

import com.pusher.client.Authorizer;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class PusherOptions {
    public static final String LIB_VERSION = PusherOptions.readVersionFromProperties();
    private static final String URI_SUFFIX = "?client=java-client&protocol=5&version=" + LIB_VERSION;
    private static final String WS_SCHEME = "ws";
    private static final String WSS_SCHEME = "wss";
    private static final int WS_PORT = 80;
    private static final int WSS_PORT = 443;
    private static final String PUSHER_DOMAIN = "pusher.com";
    private static final long DEFAULT_ACTIVITY_TIMEOUT = 120000L;
    private static final long DEFAULT_PONG_TIMEOUT = 30000L;
    private String host = "ws.pusherapp.com";
    private int wsPort = 80;
    private int wssPort = 443;
    private boolean encrypted = true;
    private long activityTimeout = 120000L;
    private long pongTimeout = 30000L;
    private Authorizer authorizer;

    public boolean isEncrypted() {
        return this.encrypted;
    }

    public PusherOptions setEncrypted(boolean encrypted) {
        this.encrypted = encrypted;
        return this;
    }

    public Authorizer getAuthorizer() {
        return this.authorizer;
    }

    public PusherOptions setAuthorizer(Authorizer authorizer) {
        this.authorizer = authorizer;
        return this;
    }

    public PusherOptions setHost(String host) {
        this.host = host;
        return this;
    }

    public PusherOptions setWsPort(int wsPort) {
        this.wsPort = wsPort;
        return this;
    }

    public PusherOptions setWssPort(int wssPort) {
        this.wssPort = wssPort;
        return this;
    }

    public PusherOptions setCluster(String cluster) {
        this.host = "ws-" + cluster + "." + PUSHER_DOMAIN;
        this.wsPort = 80;
        this.wssPort = 443;
        return this;
    }

    public PusherOptions setActivityTimeout(long activityTimeout) {
        if (activityTimeout < 1000L) {
            throw new IllegalArgumentException("Activity timeout must be at least 1,000ms (and is recommended to be much higher)");
        }
        this.activityTimeout = activityTimeout;
        return this;
    }

    public long getActivityTimeout() {
        return this.activityTimeout;
    }

    public PusherOptions setPongTimeout(long pongTimeout) {
        if (pongTimeout < 1000L) {
            throw new IllegalArgumentException("Pong timeout must be at least 1,000ms (and is recommended to be much higher)");
        }
        this.pongTimeout = pongTimeout;
        return this;
    }

    public long getPongTimeout() {
        return this.pongTimeout;
    }

    public String buildUrl(String apiKey) {
        return String.format("%s://%s:%s/app/%s%s", this.encrypted ? WSS_SCHEME : WS_SCHEME, this.host, this.encrypted ? this.wssPort : this.wsPort, apiKey, URI_SUFFIX);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readVersionFromProperties() {
        InputStream inStream = null;
        try {
            Properties p = new Properties();
            inStream = PusherOptions.class.getResourceAsStream("/pusher.properties");
            p.load(inStream);
            String version = (String)p.get("version");
            if (version != null && version.length() > 0) {
                String string = version;
                return string;
            }
        }
        catch (Exception e) {
        }
        finally {
            try {
                if (inStream != null) {
                    inStream.close();
                }
            }
            catch (IOException e) {}
        }
        return "0.0.0";
    }
}

