/*
 * Decompiled with CFR 0.152.
 */
package com.pusher.client.util;

import com.pusher.client.Authorizer;
import com.pusher.client.PusherOptions;
import com.pusher.client.channel.impl.ChannelImpl;
import com.pusher.client.channel.impl.ChannelManager;
import com.pusher.client.channel.impl.PresenceChannelImpl;
import com.pusher.client.channel.impl.PrivateChannelImpl;
import com.pusher.client.connection.impl.InternalConnection;
import com.pusher.client.connection.websocket.WebSocketClientWrapper;
import com.pusher.client.connection.websocket.WebSocketConnection;
import com.pusher.client.connection.websocket.WebSocketListener;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import javax.net.ssl.SSLException;
import org.java_websocket.client.WebSocketClient;

public class Factory {
    private InternalConnection connection;
    private ChannelManager channelManager;
    private ScheduledExecutorService eventQueue;

    public InternalConnection getConnection(String apiKey, PusherOptions options) {
        if (this.connection == null) {
            try {
                this.connection = new WebSocketConnection(options.buildUrl(apiKey), options.getActivityTimeout(), options.getPongTimeout(), this);
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException("Failed to initialise connection", e);
            }
        }
        return this.connection;
    }

    public WebSocketClient newWebSocketClientWrapper(URI uri, WebSocketListener proxy) throws SSLException {
        return new WebSocketClientWrapper(uri, proxy);
    }

    public ScheduledExecutorService getEventQueue() {
        if (this.eventQueue == null) {
            this.eventQueue = Executors.newSingleThreadScheduledExecutor();
        }
        return this.eventQueue;
    }

    public ChannelImpl newPublicChannel(String channelName) {
        return new ChannelImpl(channelName, this);
    }

    public PrivateChannelImpl newPrivateChannel(InternalConnection connection, String channelName, Authorizer authorizer) {
        return new PrivateChannelImpl(connection, channelName, authorizer, this);
    }

    public PresenceChannelImpl newPresenceChannel(InternalConnection connection, String channelName, Authorizer authorizer) {
        return new PresenceChannelImpl(connection, channelName, authorizer, this);
    }

    public ChannelManager getChannelManager() {
        if (this.channelManager == null) {
            this.channelManager = new ChannelManager(this);
        }
        return this.channelManager;
    }

    public long timeNow() {
        return System.currentTimeMillis();
    }
}

