/*
 * Decompiled with CFR 0.152.
 */
package com.pswidersk.gradle.python.sdkimport;

import com.pswidersk.gradle.python.PythonPluginExtension;
import com.pswidersk.gradle.python.PythonPluginUtilsKt;
import com.pswidersk.gradle.python.sdkimport.SdkImportUtilsKt;
import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u000f\u001a\u00020\u0010H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0006\u001a\u00020\u00078GX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001c\u0010\f\u001a\u00020\u00078GX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\t\"\u0004\b\u000e\u0010\u000b\u00a8\u0006\u0011"}, d2={"Lcom/pswidersk/gradle/python/sdkimport/SaveSdkImportConfigTask;", "Lorg/gradle/api/DefaultTask;", "<init>", "()V", "pythonPluginExtension", "Lcom/pswidersk/gradle/python/PythonPluginExtension;", "sdkConfigFile", "Ljava/io/File;", "getSdkConfigFile", "()Ljava/io/File;", "setSdkConfigFile", "(Ljava/io/File;)V", "inputFile", "getInputFile", "setInputFile", "setup", "", "python-gradle-plugin"})
public abstract class SaveSdkImportConfigTask
extends DefaultTask {
    @NotNull
    private final PythonPluginExtension pythonPluginExtension;
    public File sdkConfigFile;
    public File inputFile;

    public SaveSdkImportConfigTask() {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        this.pythonPluginExtension = PythonPluginUtilsKt.getPythonPlugin(project);
        this.setGroup("python");
        this.setDescription("Saves SDK reference to `sdk-import.yml` file.");
    }

    @OutputFile
    @NotNull
    public final File getSdkConfigFile() {
        File file = this.sdkConfigFile;
        if (file != null) {
            return file;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"sdkConfigFile");
        return null;
    }

    public final void setSdkConfigFile(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"<set-?>");
        this.sdkConfigFile = file;
    }

    @InputFile
    @NotNull
    public final File getInputFile() {
        File file = this.inputFile;
        if (file != null) {
            return file;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"inputFile");
        return null;
    }

    public final void setInputFile(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"<set-?>");
        this.inputFile = file;
    }

    @TaskAction
    public final void setup() {
        String moduleName = (String)this.pythonPluginExtension.getIntellijModuleName$python_gradle_plugin().get();
        List pythonEnvs = FilesKt.readLines$default((File)this.getInputFile(), null, (int)1, null);
        String pythonSdkPath = (String)CollectionsKt.firstOrNull((List)pythonEnvs);
        if (pythonSdkPath != null) {
            this.getLogger().info("Saving python SDK reference: " + pythonSdkPath);
            File file = this.getSdkConfigFile();
            Intrinsics.checkNotNull((Object)moduleName);
            org.gradle.api.logging.Logger logger = this.getLogger();
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
            SdkImportUtilsKt.updateSdkConfig(file, pythonSdkPath, moduleName, (Logger)logger);
        } else {
            this.getLogger().warn("No python SDK was found.");
        }
    }
}

