/*
 * Decompiled with CFR 0.152.
 */
package com.pswidersk.gradle.python;

import com.pswidersk.gradle.python.PythonPluginExtension;
import com.pswidersk.gradle.python.PythonPluginUtilsKt;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.Base64;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.apache.commons.io.FileUtils;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.Directory;
import org.gradle.api.tasks.TaskAction;
import org.gradle.process.ExecOperations;
import org.gradle.process.ExecResult;
import org.gradle.process.ExecSpec;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u000eH\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/pswidersk/gradle/python/CondaSetupTask;", "Lorg/gradle/api/DefaultTask;", "execOperations", "Lorg/gradle/process/ExecOperations;", "(Lorg/gradle/process/ExecOperations;)V", "pythonPluginExtension", "Lcom/pswidersk/gradle/python/PythonPluginExtension;", "addBasicAuth", "", "connection", "Ljava/net/URLConnection;", "addCustomHeaders", "allowInstallerExecution", "condaInstaller", "Ljava/io/File;", "downloadConda", "condaFile", "setup", "Lorg/gradle/process/ExecResult;", "python-gradle-plugin"})
public abstract class CondaSetupTask
extends DefaultTask {
    @NotNull
    private final ExecOperations execOperations;
    @NotNull
    private final PythonPluginExtension pythonPluginExtension;

    @Inject
    public CondaSetupTask(@NotNull ExecOperations execOperations) {
        Intrinsics.checkNotNullParameter((Object)execOperations, (String)"execOperations");
        this.execOperations = execOperations;
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        this.pythonPluginExtension = PythonPluginUtilsKt.getPythonPlugin(project);
        this.setGroup("python");
        this.setDescription("Setup Miniconda3");
        this.onlyIf(arg_0 -> CondaSetupTask._init_$lambda-0(this, arg_0));
    }

    @TaskAction
    @NotNull
    public final ExecResult setup() {
        PythonPluginExtension pythonPluginExtension;
        PythonPluginExtension $this$setup_u24lambda_u2d2 = pythonPluginExtension = this.pythonPluginExtension;
        boolean bl = false;
        File condaDirFile = ((Directory)$this$setup_u24lambda_u2d2.getCondaDir$python_gradle_plugin().get()).getAsFile();
        condaDirFile.mkdirs();
        Intrinsics.checkNotNullExpressionValue((Object)condaDirFile, (String)"condaDirFile");
        File condaInstaller = FilesKt.resolve((File)condaDirFile, (String)((String)$this$setup_u24lambda_u2d2.getCondaInstaller().get() + '-' + (String)$this$setup_u24lambda_u2d2.getCondaVersion().get() + '-' + PythonPluginUtilsKt.getOs() + '-' + (String)$this$setup_u24lambda_u2d2.getSystemArch().get() + '.' + PythonPluginUtilsKt.getExec()));
        this.downloadConda(condaInstaller);
        this.allowInstallerExecution(condaInstaller);
        this.getLogger().lifecycle("Installing " + (String)$this$setup_u24lambda_u2d2.getCondaInstaller().get() + "...");
        ExecResult execResult = this.execOperations.exec(arg_0 -> CondaSetupTask.setup$lambda-2$lambda-1(condaInstaller, condaDirFile, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)execResult, (String)"with(pythonPluginExtensi\u2026execArgs)\n        }\n    }");
        return execResult;
    }

    private final void allowInstallerExecution(File condaInstaller) {
        if (!PythonPluginUtilsKt.isWindows()) {
            this.getLogger().lifecycle("Allowing user to run installer...");
            this.execOperations.exec(arg_0 -> CondaSetupTask.allowInstallerExecution$lambda-3(condaInstaller, arg_0));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void downloadConda(File condaFile) {
        String string;
        block2: {
            Object object = this.pythonPluginExtension.getCondaRepoUrl().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"pythonPluginExtension.condaRepoUrl.get()");
            String $this$dropLastWhile$iv = (String)object;
            boolean $i$f$dropLastWhile = false;
            int n = StringsKt.getLastIndex((CharSequence)$this$dropLastWhile$iv);
            while (n >= 0) {
                void index$iv;
                char it = $this$dropLastWhile$iv.charAt((int)index$iv);
                boolean bl = false;
                if (!(it == '/')) {
                    String string2 = $this$dropLastWhile$iv;
                    int n2 = 0;
                    void var8_10 = index$iv + true;
                    String string3 = string2.substring(n2, (int)var8_10);
                    string = string3;
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    break block2;
                }
                --index$iv;
            }
            string = "";
        }
        String condaRepoUrl = string;
        String condaInstaller = (String)this.pythonPluginExtension.getCondaInstaller().get();
        this.getLogger().lifecycle("Downloading " + condaInstaller + " to: " + condaFile.getCanonicalPath() + " from: " + condaRepoUrl + " (please wait, it can take a while)");
        URLConnection connection = new URL(condaRepoUrl + '/' + condaFile.getName()).openConnection();
        Intrinsics.checkNotNullExpressionValue((Object)connection, (String)"connection");
        this.addBasicAuth(connection);
        this.addCustomHeaders(connection);
        InputStream condaInputStream = connection.getInputStream();
        FileUtils.copyInputStreamToFile((InputStream)condaInputStream, (File)condaFile);
    }

    private final void addBasicAuth(URLConnection connection) {
        if (this.pythonPluginExtension.getCondaRepoUsername().isPresent()) {
            String condaRepoUsername = (String)this.pythonPluginExtension.getCondaRepoUsername().get();
            String condaRepoPassword = (String)this.pythonPluginExtension.getCondaRepoPassword().get();
            this.getLogger().lifecycle("Adding basic authorization headers for '" + condaRepoUsername + "' user.");
            String userAndPass = condaRepoUsername + ':' + condaRepoPassword;
            StringBuilder stringBuilder = new StringBuilder().append("Basic ");
            Base64.Encoder encoder = Base64.getEncoder();
            String string = userAndPass;
            Charset charset = Charsets.UTF_8;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            byte[] byArray = string2.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
            byte[] byArray2 = encoder.encode(byArray);
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"getEncoder().encode(userAndPass.toByteArray())");
            byte[] byArray3 = byArray2;
            String basicAuth = stringBuilder.append(new String(byArray3, Charsets.UTF_8)).toString();
            connection.setRequestProperty("Authorization", basicAuth);
        }
    }

    private final void addCustomHeaders(URLConnection connection) {
        Map condaRepoHeaders = (Map)this.pythonPluginExtension.getCondaRepoHeaders().get();
        Intrinsics.checkNotNullExpressionValue((Object)condaRepoHeaders, (String)"condaRepoHeaders");
        Map $this$forEach$iv = condaRepoHeaders;
        boolean $i$f$forEach = false;
        Map map = $this$forEach$iv;
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry it = element$iv = iterator.next();
            boolean bl = false;
            connection.addRequestProperty((String)it.getKey(), (String)it.getValue());
        }
    }

    private static final boolean _init_$lambda-0(CondaSetupTask this$0, Task it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        return !((Directory)this$0.pythonPluginExtension.getCondaBinDir$python_gradle_plugin().get()).getAsFile().exists();
    }

    private static final void setup$lambda-2$lambda-1(File $condaInstaller, File $condaDirFile, ExecSpec it) {
        List list;
        Object[] objectArray;
        Intrinsics.checkNotNullParameter((Object)$condaInstaller, (String)"$condaInstaller");
        it.setExecutable($condaInstaller.getCanonicalPath());
        if (PythonPluginUtilsKt.isWindows()) {
            objectArray = new String[]{"/InstallationType=JustMe", "/RegisterPython=0", "/AddToPath=0", "/S", "/D=" + $condaDirFile.getCanonicalPath()};
            list = CollectionsKt.listOf((Object[])objectArray);
        } else {
            objectArray = new String[]{"-b", "-u", "-p", $condaDirFile.getCanonicalPath()};
            list = CollectionsKt.listOf((Object[])objectArray);
        }
        List execArgs = list;
        it.args((Iterable)execArgs);
    }

    private static final void allowInstallerExecution$lambda-3(File $condaInstaller, ExecSpec it) {
        Intrinsics.checkNotNullParameter((Object)$condaInstaller, (String)"$condaInstaller");
        it.setExecutable("chmod");
        Object[] objectArray = new Object[]{"u+x", $condaInstaller.getCanonicalPath()};
        it.args(objectArray);
    }
}

