/*
 * Decompiled with CFR 0.152.
 */
package com.prove.proveapi.models.errors;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.prove.proveapi.utils.Utils;
import java.util.Objects;
import java.util.Optional;

public class Error400
extends RuntimeException {
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="code")
    private Optional<Long> code;
    @JsonProperty(value="message")
    private String message;

    @JsonCreator
    public Error400(@JsonProperty(value="code") Optional<Long> code, @JsonProperty(value="message") String message) {
        super(message);
        Utils.checkNotNull(code, "code");
        Utils.checkNotNull(message, "message");
        this.code = code;
        this.message = message;
    }

    public Error400(String message) {
        this(Optional.empty(), message);
    }

    public Optional<Long> code() {
        return this.code;
    }

    public String message() {
        return this.message;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public Error400 withCode(long code) {
        Utils.checkNotNull(code, "code");
        this.code = Optional.ofNullable(code);
        return this;
    }

    public Error400 withCode(Optional<Long> code) {
        Utils.checkNotNull(code, "code");
        this.code = code;
        return this;
    }

    public Error400 withMessage(String message) {
        Utils.checkNotNull(message, "message");
        this.message = message;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Error400 other = (Error400)o;
        return Objects.deepEquals(this.code, other.code) && Objects.deepEquals(this.message, other.message);
    }

    public int hashCode() {
        return Objects.hash(this.code, this.message);
    }

    @Override
    public String toString() {
        return Utils.toString(Error400.class, "code", this.code, "message", this.message);
    }

    public static final class Builder {
        private Optional<Long> code = Optional.empty();
        private String message;

        private Builder() {
        }

        public Builder code(long code) {
            Utils.checkNotNull(code, "code");
            this.code = Optional.ofNullable(code);
            return this;
        }

        public Builder code(Optional<Long> code) {
            Utils.checkNotNull(code, "code");
            this.code = code;
            return this;
        }

        public Builder message(String message) {
            Utils.checkNotNull(message, "message");
            this.message = message;
            return this;
        }

        public Error400 build() {
            return new Error400(this.code, this.message);
        }
    }
}

