/*
 * Decompiled with CFR 0.152.
 */
package com.prove.proveapi.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.prove.proveapi.utils.Utils;
import java.util.Objects;
import java.util.Optional;

public class V3VerifyRequest {
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="clientCustomerId")
    private Optional<String> clientCustomerId;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="clientRequestId")
    private Optional<String> clientRequestId;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="emailAddress")
    private Optional<String> emailAddress;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="finalTargetUrl")
    private Optional<String> finalTargetUrl;
    @JsonProperty(value="firstName")
    private String firstName;
    @JsonProperty(value="lastName")
    private String lastName;
    @JsonProperty(value="phoneNumber")
    private String phoneNumber;
    @JsonProperty(value="possessionType")
    private String possessionType;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="smsMessage")
    private Optional<String> smsMessage;

    @JsonCreator
    public V3VerifyRequest(@JsonProperty(value="clientCustomerId") Optional<String> clientCustomerId, @JsonProperty(value="clientRequestId") Optional<String> clientRequestId, @JsonProperty(value="emailAddress") Optional<String> emailAddress, @JsonProperty(value="finalTargetUrl") Optional<String> finalTargetUrl, @JsonProperty(value="firstName") String firstName, @JsonProperty(value="lastName") String lastName, @JsonProperty(value="phoneNumber") String phoneNumber, @JsonProperty(value="possessionType") String possessionType, @JsonProperty(value="smsMessage") Optional<String> smsMessage) {
        Utils.checkNotNull(clientCustomerId, "clientCustomerId");
        Utils.checkNotNull(clientRequestId, "clientRequestId");
        Utils.checkNotNull(emailAddress, "emailAddress");
        Utils.checkNotNull(finalTargetUrl, "finalTargetUrl");
        Utils.checkNotNull(firstName, "firstName");
        Utils.checkNotNull(lastName, "lastName");
        Utils.checkNotNull(phoneNumber, "phoneNumber");
        Utils.checkNotNull(possessionType, "possessionType");
        Utils.checkNotNull(smsMessage, "smsMessage");
        this.clientCustomerId = clientCustomerId;
        this.clientRequestId = clientRequestId;
        this.emailAddress = emailAddress;
        this.finalTargetUrl = finalTargetUrl;
        this.firstName = firstName;
        this.lastName = lastName;
        this.phoneNumber = phoneNumber;
        this.possessionType = possessionType;
        this.smsMessage = smsMessage;
    }

    public V3VerifyRequest(String firstName, String lastName, String phoneNumber, String possessionType) {
        this(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), firstName, lastName, phoneNumber, possessionType, Optional.empty());
    }

    @JsonIgnore
    public Optional<String> clientCustomerId() {
        return this.clientCustomerId;
    }

    @JsonIgnore
    public Optional<String> clientRequestId() {
        return this.clientRequestId;
    }

    @JsonIgnore
    public Optional<String> emailAddress() {
        return this.emailAddress;
    }

    @JsonIgnore
    public Optional<String> finalTargetUrl() {
        return this.finalTargetUrl;
    }

    @JsonIgnore
    public String firstName() {
        return this.firstName;
    }

    @JsonIgnore
    public String lastName() {
        return this.lastName;
    }

    @JsonIgnore
    public String phoneNumber() {
        return this.phoneNumber;
    }

    @JsonIgnore
    public String possessionType() {
        return this.possessionType;
    }

    @JsonIgnore
    public Optional<String> smsMessage() {
        return this.smsMessage;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public V3VerifyRequest withClientCustomerId(String clientCustomerId) {
        Utils.checkNotNull(clientCustomerId, "clientCustomerId");
        this.clientCustomerId = Optional.ofNullable(clientCustomerId);
        return this;
    }

    public V3VerifyRequest withClientCustomerId(Optional<String> clientCustomerId) {
        Utils.checkNotNull(clientCustomerId, "clientCustomerId");
        this.clientCustomerId = clientCustomerId;
        return this;
    }

    public V3VerifyRequest withClientRequestId(String clientRequestId) {
        Utils.checkNotNull(clientRequestId, "clientRequestId");
        this.clientRequestId = Optional.ofNullable(clientRequestId);
        return this;
    }

    public V3VerifyRequest withClientRequestId(Optional<String> clientRequestId) {
        Utils.checkNotNull(clientRequestId, "clientRequestId");
        this.clientRequestId = clientRequestId;
        return this;
    }

    public V3VerifyRequest withEmailAddress(String emailAddress) {
        Utils.checkNotNull(emailAddress, "emailAddress");
        this.emailAddress = Optional.ofNullable(emailAddress);
        return this;
    }

    public V3VerifyRequest withEmailAddress(Optional<String> emailAddress) {
        Utils.checkNotNull(emailAddress, "emailAddress");
        this.emailAddress = emailAddress;
        return this;
    }

    public V3VerifyRequest withFinalTargetUrl(String finalTargetUrl) {
        Utils.checkNotNull(finalTargetUrl, "finalTargetUrl");
        this.finalTargetUrl = Optional.ofNullable(finalTargetUrl);
        return this;
    }

    public V3VerifyRequest withFinalTargetUrl(Optional<String> finalTargetUrl) {
        Utils.checkNotNull(finalTargetUrl, "finalTargetUrl");
        this.finalTargetUrl = finalTargetUrl;
        return this;
    }

    public V3VerifyRequest withFirstName(String firstName) {
        Utils.checkNotNull(firstName, "firstName");
        this.firstName = firstName;
        return this;
    }

    public V3VerifyRequest withLastName(String lastName) {
        Utils.checkNotNull(lastName, "lastName");
        this.lastName = lastName;
        return this;
    }

    public V3VerifyRequest withPhoneNumber(String phoneNumber) {
        Utils.checkNotNull(phoneNumber, "phoneNumber");
        this.phoneNumber = phoneNumber;
        return this;
    }

    public V3VerifyRequest withPossessionType(String possessionType) {
        Utils.checkNotNull(possessionType, "possessionType");
        this.possessionType = possessionType;
        return this;
    }

    public V3VerifyRequest withSmsMessage(String smsMessage) {
        Utils.checkNotNull(smsMessage, "smsMessage");
        this.smsMessage = Optional.ofNullable(smsMessage);
        return this;
    }

    public V3VerifyRequest withSmsMessage(Optional<String> smsMessage) {
        Utils.checkNotNull(smsMessage, "smsMessage");
        this.smsMessage = smsMessage;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V3VerifyRequest other = (V3VerifyRequest)o;
        return Objects.deepEquals(this.clientCustomerId, other.clientCustomerId) && Objects.deepEquals(this.clientRequestId, other.clientRequestId) && Objects.deepEquals(this.emailAddress, other.emailAddress) && Objects.deepEquals(this.finalTargetUrl, other.finalTargetUrl) && Objects.deepEquals(this.firstName, other.firstName) && Objects.deepEquals(this.lastName, other.lastName) && Objects.deepEquals(this.phoneNumber, other.phoneNumber) && Objects.deepEquals(this.possessionType, other.possessionType) && Objects.deepEquals(this.smsMessage, other.smsMessage);
    }

    public int hashCode() {
        return Objects.hash(this.clientCustomerId, this.clientRequestId, this.emailAddress, this.finalTargetUrl, this.firstName, this.lastName, this.phoneNumber, this.possessionType, this.smsMessage);
    }

    public String toString() {
        return Utils.toString(V3VerifyRequest.class, "clientCustomerId", this.clientCustomerId, "clientRequestId", this.clientRequestId, "emailAddress", this.emailAddress, "finalTargetUrl", this.finalTargetUrl, "firstName", this.firstName, "lastName", this.lastName, "phoneNumber", this.phoneNumber, "possessionType", this.possessionType, "smsMessage", this.smsMessage);
    }

    public static final class Builder {
        private Optional<String> clientCustomerId = Optional.empty();
        private Optional<String> clientRequestId = Optional.empty();
        private Optional<String> emailAddress = Optional.empty();
        private Optional<String> finalTargetUrl = Optional.empty();
        private String firstName;
        private String lastName;
        private String phoneNumber;
        private String possessionType;
        private Optional<String> smsMessage = Optional.empty();

        private Builder() {
        }

        public Builder clientCustomerId(String clientCustomerId) {
            Utils.checkNotNull(clientCustomerId, "clientCustomerId");
            this.clientCustomerId = Optional.ofNullable(clientCustomerId);
            return this;
        }

        public Builder clientCustomerId(Optional<String> clientCustomerId) {
            Utils.checkNotNull(clientCustomerId, "clientCustomerId");
            this.clientCustomerId = clientCustomerId;
            return this;
        }

        public Builder clientRequestId(String clientRequestId) {
            Utils.checkNotNull(clientRequestId, "clientRequestId");
            this.clientRequestId = Optional.ofNullable(clientRequestId);
            return this;
        }

        public Builder clientRequestId(Optional<String> clientRequestId) {
            Utils.checkNotNull(clientRequestId, "clientRequestId");
            this.clientRequestId = clientRequestId;
            return this;
        }

        public Builder emailAddress(String emailAddress) {
            Utils.checkNotNull(emailAddress, "emailAddress");
            this.emailAddress = Optional.ofNullable(emailAddress);
            return this;
        }

        public Builder emailAddress(Optional<String> emailAddress) {
            Utils.checkNotNull(emailAddress, "emailAddress");
            this.emailAddress = emailAddress;
            return this;
        }

        public Builder finalTargetUrl(String finalTargetUrl) {
            Utils.checkNotNull(finalTargetUrl, "finalTargetUrl");
            this.finalTargetUrl = Optional.ofNullable(finalTargetUrl);
            return this;
        }

        public Builder finalTargetUrl(Optional<String> finalTargetUrl) {
            Utils.checkNotNull(finalTargetUrl, "finalTargetUrl");
            this.finalTargetUrl = finalTargetUrl;
            return this;
        }

        public Builder firstName(String firstName) {
            Utils.checkNotNull(firstName, "firstName");
            this.firstName = firstName;
            return this;
        }

        public Builder lastName(String lastName) {
            Utils.checkNotNull(lastName, "lastName");
            this.lastName = lastName;
            return this;
        }

        public Builder phoneNumber(String phoneNumber) {
            Utils.checkNotNull(phoneNumber, "phoneNumber");
            this.phoneNumber = phoneNumber;
            return this;
        }

        public Builder possessionType(String possessionType) {
            Utils.checkNotNull(possessionType, "possessionType");
            this.possessionType = possessionType;
            return this;
        }

        public Builder smsMessage(String smsMessage) {
            Utils.checkNotNull(smsMessage, "smsMessage");
            this.smsMessage = Optional.ofNullable(smsMessage);
            return this;
        }

        public Builder smsMessage(Optional<String> smsMessage) {
            Utils.checkNotNull(smsMessage, "smsMessage");
            this.smsMessage = smsMessage;
            return this;
        }

        public V3VerifyRequest build() {
            return new V3VerifyRequest(this.clientCustomerId, this.clientRequestId, this.emailAddress, this.finalTargetUrl, this.firstName, this.lastName, this.phoneNumber, this.possessionType, this.smsMessage);
        }
    }
}

