/*
 * Decompiled with CFR 0.152.
 */
package com.prove.proveapi.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.prove.proveapi.utils.Utils;
import java.util.Objects;
import java.util.Optional;

public class V3TokenResponse {
    @JsonProperty(value="access_token")
    private String accessToken;
    @JsonProperty(value="expires_in")
    private long expiresIn;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="refresh_expires_in")
    private Optional<Long> refreshExpiresIn;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="refresh_token")
    private Optional<String> refreshToken;
    @JsonProperty(value="token_type")
    private String tokenType;

    @JsonCreator
    public V3TokenResponse(@JsonProperty(value="access_token") String accessToken, @JsonProperty(value="expires_in") long expiresIn, @JsonProperty(value="refresh_expires_in") Optional<Long> refreshExpiresIn, @JsonProperty(value="refresh_token") Optional<String> refreshToken, @JsonProperty(value="token_type") String tokenType) {
        Utils.checkNotNull(accessToken, "accessToken");
        Utils.checkNotNull(expiresIn, "expiresIn");
        Utils.checkNotNull(refreshExpiresIn, "refreshExpiresIn");
        Utils.checkNotNull(refreshToken, "refreshToken");
        Utils.checkNotNull(tokenType, "tokenType");
        this.accessToken = accessToken;
        this.expiresIn = expiresIn;
        this.refreshExpiresIn = refreshExpiresIn;
        this.refreshToken = refreshToken;
        this.tokenType = tokenType;
    }

    public V3TokenResponse(String accessToken, long expiresIn, String tokenType) {
        this(accessToken, expiresIn, Optional.empty(), Optional.empty(), tokenType);
    }

    @JsonIgnore
    public String accessToken() {
        return this.accessToken;
    }

    @JsonIgnore
    public long expiresIn() {
        return this.expiresIn;
    }

    @JsonIgnore
    public Optional<Long> refreshExpiresIn() {
        return this.refreshExpiresIn;
    }

    @JsonIgnore
    public Optional<String> refreshToken() {
        return this.refreshToken;
    }

    @JsonIgnore
    public String tokenType() {
        return this.tokenType;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public V3TokenResponse withAccessToken(String accessToken) {
        Utils.checkNotNull(accessToken, "accessToken");
        this.accessToken = accessToken;
        return this;
    }

    public V3TokenResponse withExpiresIn(long expiresIn) {
        Utils.checkNotNull(expiresIn, "expiresIn");
        this.expiresIn = expiresIn;
        return this;
    }

    public V3TokenResponse withRefreshExpiresIn(long refreshExpiresIn) {
        Utils.checkNotNull(refreshExpiresIn, "refreshExpiresIn");
        this.refreshExpiresIn = Optional.ofNullable(refreshExpiresIn);
        return this;
    }

    public V3TokenResponse withRefreshExpiresIn(Optional<Long> refreshExpiresIn) {
        Utils.checkNotNull(refreshExpiresIn, "refreshExpiresIn");
        this.refreshExpiresIn = refreshExpiresIn;
        return this;
    }

    public V3TokenResponse withRefreshToken(String refreshToken) {
        Utils.checkNotNull(refreshToken, "refreshToken");
        this.refreshToken = Optional.ofNullable(refreshToken);
        return this;
    }

    public V3TokenResponse withRefreshToken(Optional<String> refreshToken) {
        Utils.checkNotNull(refreshToken, "refreshToken");
        this.refreshToken = refreshToken;
        return this;
    }

    public V3TokenResponse withTokenType(String tokenType) {
        Utils.checkNotNull(tokenType, "tokenType");
        this.tokenType = tokenType;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V3TokenResponse other = (V3TokenResponse)o;
        return Objects.deepEquals(this.accessToken, other.accessToken) && Objects.deepEquals(this.expiresIn, other.expiresIn) && Objects.deepEquals(this.refreshExpiresIn, other.refreshExpiresIn) && Objects.deepEquals(this.refreshToken, other.refreshToken) && Objects.deepEquals(this.tokenType, other.tokenType);
    }

    public int hashCode() {
        return Objects.hash(this.accessToken, this.expiresIn, this.refreshExpiresIn, this.refreshToken, this.tokenType);
    }

    public String toString() {
        return Utils.toString(V3TokenResponse.class, "accessToken", this.accessToken, "expiresIn", this.expiresIn, "refreshExpiresIn", this.refreshExpiresIn, "refreshToken", this.refreshToken, "tokenType", this.tokenType);
    }

    public static final class Builder {
        private String accessToken;
        private Long expiresIn;
        private Optional<Long> refreshExpiresIn = Optional.empty();
        private Optional<String> refreshToken = Optional.empty();
        private String tokenType;

        private Builder() {
        }

        public Builder accessToken(String accessToken) {
            Utils.checkNotNull(accessToken, "accessToken");
            this.accessToken = accessToken;
            return this;
        }

        public Builder expiresIn(long expiresIn) {
            Utils.checkNotNull(expiresIn, "expiresIn");
            this.expiresIn = expiresIn;
            return this;
        }

        public Builder refreshExpiresIn(long refreshExpiresIn) {
            Utils.checkNotNull(refreshExpiresIn, "refreshExpiresIn");
            this.refreshExpiresIn = Optional.ofNullable(refreshExpiresIn);
            return this;
        }

        public Builder refreshExpiresIn(Optional<Long> refreshExpiresIn) {
            Utils.checkNotNull(refreshExpiresIn, "refreshExpiresIn");
            this.refreshExpiresIn = refreshExpiresIn;
            return this;
        }

        public Builder refreshToken(String refreshToken) {
            Utils.checkNotNull(refreshToken, "refreshToken");
            this.refreshToken = Optional.ofNullable(refreshToken);
            return this;
        }

        public Builder refreshToken(Optional<String> refreshToken) {
            Utils.checkNotNull(refreshToken, "refreshToken");
            this.refreshToken = refreshToken;
            return this;
        }

        public Builder tokenType(String tokenType) {
            Utils.checkNotNull(tokenType, "tokenType");
            this.tokenType = tokenType;
            return this;
        }

        public V3TokenResponse build() {
            return new V3TokenResponse(this.accessToken, this.expiresIn, this.refreshExpiresIn, this.refreshToken, this.tokenType);
        }
    }
}

