/*
 * Decompiled with CFR 0.152.
 */
package com.prove.proveapi.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.prove.proveapi.utils.Utils;
import java.util.Objects;
import java.util.Optional;

public class V3ChallengeRequest {
    @JsonProperty(value="correlationId")
    private String correlationId;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="dob")
    private Optional<String> dob;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="ssn")
    private Optional<String> ssn;

    @JsonCreator
    public V3ChallengeRequest(@JsonProperty(value="correlationId") String correlationId, @JsonProperty(value="dob") Optional<String> dob, @JsonProperty(value="ssn") Optional<String> ssn) {
        Utils.checkNotNull(correlationId, "correlationId");
        Utils.checkNotNull(dob, "dob");
        Utils.checkNotNull(ssn, "ssn");
        this.correlationId = correlationId;
        this.dob = dob;
        this.ssn = ssn;
    }

    public V3ChallengeRequest(String correlationId) {
        this(correlationId, Optional.empty(), Optional.empty());
    }

    @JsonIgnore
    public String correlationId() {
        return this.correlationId;
    }

    @JsonIgnore
    public Optional<String> dob() {
        return this.dob;
    }

    @JsonIgnore
    public Optional<String> ssn() {
        return this.ssn;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public V3ChallengeRequest withCorrelationId(String correlationId) {
        Utils.checkNotNull(correlationId, "correlationId");
        this.correlationId = correlationId;
        return this;
    }

    public V3ChallengeRequest withDob(String dob) {
        Utils.checkNotNull(dob, "dob");
        this.dob = Optional.ofNullable(dob);
        return this;
    }

    public V3ChallengeRequest withDob(Optional<String> dob) {
        Utils.checkNotNull(dob, "dob");
        this.dob = dob;
        return this;
    }

    public V3ChallengeRequest withSsn(String ssn) {
        Utils.checkNotNull(ssn, "ssn");
        this.ssn = Optional.ofNullable(ssn);
        return this;
    }

    public V3ChallengeRequest withSsn(Optional<String> ssn) {
        Utils.checkNotNull(ssn, "ssn");
        this.ssn = ssn;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V3ChallengeRequest other = (V3ChallengeRequest)o;
        return Objects.deepEquals(this.correlationId, other.correlationId) && Objects.deepEquals(this.dob, other.dob) && Objects.deepEquals(this.ssn, other.ssn);
    }

    public int hashCode() {
        return Objects.hash(this.correlationId, this.dob, this.ssn);
    }

    public String toString() {
        return Utils.toString(V3ChallengeRequest.class, "correlationId", this.correlationId, "dob", this.dob, "ssn", this.ssn);
    }

    public static final class Builder {
        private String correlationId;
        private Optional<String> dob = Optional.empty();
        private Optional<String> ssn = Optional.empty();

        private Builder() {
        }

        public Builder correlationId(String correlationId) {
            Utils.checkNotNull(correlationId, "correlationId");
            this.correlationId = correlationId;
            return this;
        }

        public Builder dob(String dob) {
            Utils.checkNotNull(dob, "dob");
            this.dob = Optional.ofNullable(dob);
            return this;
        }

        public Builder dob(Optional<String> dob) {
            Utils.checkNotNull(dob, "dob");
            this.dob = dob;
            return this;
        }

        public Builder ssn(String ssn) {
            Utils.checkNotNull(ssn, "ssn");
            this.ssn = Optional.ofNullable(ssn);
            return this;
        }

        public Builder ssn(Optional<String> ssn) {
            Utils.checkNotNull(ssn, "ssn");
            this.ssn = ssn;
            return this;
        }

        public V3ChallengeRequest build() {
            return new V3ChallengeRequest(this.correlationId, this.dob, this.ssn);
        }
    }
}

