package com.proton.ecgcard.algorithm.interfaces;

import android.os.Handler;
import android.os.Looper;

import com.proton.ecgcard.algorithm.bean.AlgorithmResult;
import com.proton.ecgcard.algorithm.bean.InsparaData;
import com.proton.ecgcard.algorithm.bean.RealECGData;
import com.proton.ecgcard.algorithm.callback.AlgorithmResultListener;
import com.proton.ecgcard.algorithm.utils.FilterAlgorithmHelper;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by 王梦思 on 2017/8/8.
 * 心电卡用户版本算法处理
 */

public class CardFilterAlgorithm implements IFilterAlgorithm {

    private Handler mainHandler = new Handler(Looper.getMainLooper());

    @Override
    public RealECGData processEcgData(List<Float> datas, long section, int sample, int band50Switch, int band100Switch, int lowpassSwitch, int highpassSwitch, int smoothSwitch) {
        double[] mDealingData = new double[datas.size()];
        for (int i = 0; i < datas.size(); i++) {
            mDealingData[i] = datas.get(i);
        }
        return FilterAlgorithmHelper.processEcgData(mDealingData, section, sample, band50Switch, band100Switch, lowpassSwitch, highpassSwitch, smoothSwitch);
    }

    @Override
    public void fullAnalyse(final List<Float> ecgDatas, final int sample, final int band50Switch, final int band100Switch, final int lowpassSwitch, final int highpassSwitch, final int smoothSwitch, final AlgorithmResultListener listener) {
        new Thread(new Runnable() {
            @Override
            public void run() {
                final AlgorithmResult result = fullAnalyse(ecgDatas, sample, band50Switch, band100Switch, lowpassSwitch, highpassSwitch, smoothSwitch);
                mainHandler.post(new Runnable() {
                    @Override
                    public void run() {
                        if (result != null && listener != null) {
                            listener.receiveAlgorithmResult(result);
                        }
                    }
                });
            }
        }).start();
    }

    @Override
    public AlgorithmResult fullAnalyse(List<Float> ecgDatas, final int sample, final int band50Switch, final int band100Switch, final int lowpassSwitch, final int highpassSwitch, final int smoothSwitch) {
        final List<Float> ecgSourceData = new ArrayList<>(ecgDatas);
        double[] ecgDatasArr = new double[ecgSourceData.size()];
        for (int i = 0; i < ecgDatasArr.length; i++) {
            ecgDatasArr[i] = ecgSourceData.get(i);
        }
        AlgorithmResult result = FilterAlgorithmHelper.fullanalyse(ecgDatasArr, sample, band50Switch, band100Switch, lowpassSwitch, highpassSwitch, smoothSwitch);
        ecgSourceData.clear();
        return result;
    }

    @Override
    public InsparaData insparaHrvData(List<Float> datas, int heartRate, int signalQualityIndex, long section, int sampr, int age) {
        double[] dealingDatas = new double[datas.size()];
        for (int i = 0; i < datas.size(); i++) {
            dealingDatas[i] = datas.get(i);
        }
        return FilterAlgorithmHelper.insparaHrvData(dealingDatas, heartRate, signalQualityIndex, section, sampr, age);
    }

    @Override
    public int dataModified(int[] userStatus, boolean[] drugStatus) {
        return FilterAlgorithmHelper.dataModified(userStatus, drugStatus);
    }
}
