package com.proton.ecgcard.algorithm.bean;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * Created by 王梦思 on 2018/7/7.
 * 算法结果
 */
public class AlgorithmResult implements Serializable {
    /**
     * 滤波心电数据
     */
    private List<Float> filterDatas = new ArrayList<>();
    /**
     * 心电原始数据
     */
    private List<Float> sourceDatas = new ArrayList<>();
    /**
     * 实时心率
     */
    private int heartRate;
    /**
     * 实时情绪指标: -1 错误; 0 抑郁; 1 沮丧; 2 正常; 3 紧张; 4 焦虑
     */
    private int emotionIndex;
    /**
     * 实时情绪得分: -100 ~ 100 正常值
     */
    private int emotionScore;
    /**
     * 实时压力指标：-1 错误; 0 正常; 1 轻度; 2 中度; 3 重度
     */
    private int stressIndex;
    /**
     * 实时压力得分：-1 错误; 5 ~ 100 正常值
     */
    private int stressScore;
    /**
     * 实时饮酒风险指标：-1 错误; 0 中低; 1 中; 2 中高; 3 高; 4 极高
     */
    private int alcholRiskIndex;
    /**
     * 实时饮酒风险指数：-1 错误; 30 ~ 100 正常值
     */
    private int alcholRiskScore;
    /**
     * 体脂率
     */
    private double bodyFatRatio;
    /**
     * 体脂率指标：-1 错误; 0 偏瘦; 1 标准; 2 偏胖; 3 过胖
     */
    private int bodyFatIndex;
    /**
     * 早搏
     */
    private int prematureBeat;
    /**
     * 房颤
     */
    private int atrialFibrillation;
    /**
     * 表征未被剔除的R峰占总R峰的百分比（变量是0-1之间的小数）
     */
    private double RRpercent;
    /**
     * 减分项数组 依次为 心脏健康减分、体脂率减分、情绪项减分、压力项减分
     */
    private int[] minusItem;
    /**
     * 心动过速时间，单位毫秒
     */
    private long heartFastTime;
    /**
     * 心动过缓时间，单位毫秒
     */
    private long heartSlowTime;
    private List<Integer> peakSums = new ArrayList<>();
    /**
     * R峰总数
     */
    private int peaksum;
    /**
     * 用于表征正常(0)、心动过缓(1)、心动过速(2)
     */
    private int heartPace;
    /**
     * 最高心率
     */
    private int highestRate;
    /**
     * 最低心率
     */
    private int lowestRate;

    public int getHeartRate() {
        return heartRate;
    }

    public void setHeartRate(int heartRate) {
        this.heartRate = heartRate;
    }

    public int getEmotionIndex() {
        return emotionIndex;
    }

    public void setEmotionIndex(int emotionIndex) {
        this.emotionIndex = emotionIndex;
    }

    public int getEmotionScore() {
        return emotionScore;
    }

    public void setEmotionScore(int emotionScore) {
        this.emotionScore = emotionScore;
    }

    public int getStressIndex() {
        return stressIndex;
    }

    public void setStressIndex(int stressIndex) {
        this.stressIndex = stressIndex;
    }

    public int getStressScore() {
        return stressScore;
    }

    public void setStressScore(int stressScore) {
        this.stressScore = stressScore;
    }

    public int getAlcholRiskIndex() {
        return alcholRiskIndex;
    }

    public void setAlcholRiskIndex(int alcholRiskIndex) {
        this.alcholRiskIndex = alcholRiskIndex;
    }

    public int getAlcholRiskScore() {
        return alcholRiskScore;
    }

    public void setAlcholRiskScore(int alcholRiskScore) {
        this.alcholRiskScore = alcholRiskScore;
    }

    public double getBodyFatRatio() {
        return bodyFatRatio;
    }

    public void setBodyFatRatio(double bodyFatRatio) {
        this.bodyFatRatio = bodyFatRatio;
    }

    public int getBodyFatIndex() {
        return bodyFatIndex;
    }

    public void setBodyFatIndex(int bodyFatIndex) {
        this.bodyFatIndex = bodyFatIndex;
    }

    public int getPrematureBeat() {
        return prematureBeat;
    }

    public void setPrematureBeat(int prematureBeat) {
        this.prematureBeat = prematureBeat;
    }

    public int getAtrialFibrillation() {
        return atrialFibrillation;
    }

    public void setAtrialFibrillation(int atrialFibrillation) {
        this.atrialFibrillation = atrialFibrillation;
    }

    public double getRRpercent() {
        return RRpercent;
    }

    public void setRRpercent(double RRpercent) {
        this.RRpercent = RRpercent;
    }

    public int[] getMinusItem() {
        return minusItem;
    }

    public void setMinusItem(int[] minusItem) {
        this.minusItem = minusItem;
    }

    public long getHeartFastTime() {
        return heartFastTime;
    }

    public void setHeartFastTime(long heartFastTime) {
        this.heartFastTime = heartFastTime;
    }

    public long getHeartSlowTime() {
        return heartSlowTime;
    }

    public void setHeartSlowTime(long heartSlowTime) {
        this.heartSlowTime = heartSlowTime;
    }

    public List<Integer> getPeakSums() {
        return peakSums;
    }

    public void setPeak(List<Integer> peakSums) {
        this.peakSums = peakSums;
    }

    public int getPeaksum() {
        return peaksum;
    }

    public void setPeaksum(int peaksum) {
        this.peaksum = peaksum;
    }

    public List<Float> getFilterDatas() {
        return filterDatas;
    }

    public void setFilterDatas(List<Float> filterDatas) {
        this.filterDatas = filterDatas;
    }

    public List<Float> getSourceDatas() {
        return sourceDatas;
    }

    public void setSourceDatas(List<Float> sourceDatas) {
        this.sourceDatas = sourceDatas;
    }

    public int getHeartPace() {
        return heartPace;
    }

    public void setHeartPace(int heartPace) {
        this.heartPace = heartPace;
    }

    public int getHighestRate() {
        return highestRate;
    }

    public void setHighestRate(int highestRate) {
        this.highestRate = highestRate;
    }

    public int getLowestRate() {
        return lowestRate;
    }

    public void setLowestRate(int lowestRate) {
        this.lowestRate = lowestRate;
    }
}
