/*
 * Decompiled with CFR 0.152.
 */
package nnumbers.NumberToString;

import math.math.math;
import references.references.CharacterReference;
import references.references.StringReference;
import strstrings.strings.strings;

public class NumberToString {
    public static char[] nCreateStringScientificNotationDecimalFromNumber(double decimal) {
        boolean isPositive;
        StringReference mantissaReference = new StringReference();
        StringReference exponentReference = new StringReference();
        char[] result = new char[]{};
        boolean done = false;
        double exponent = 0.0;
        if (decimal < 0.0) {
            isPositive = false;
            decimal = -decimal;
        } else {
            isPositive = true;
        }
        if (decimal == 0.0) {
            done = true;
        }
        if (!done) {
            double multiplier = 0.0;
            double inc = 0.0;
            if (decimal < 1.0) {
                multiplier = 10.0;
                inc = -1.0;
            } else if (decimal >= 10.0) {
                multiplier = 0.1;
                inc = 1.0;
            } else {
                done = true;
            }
            if (!done) {
                while (decimal >= 10.0 || decimal < 1.0) {
                    decimal *= multiplier;
                    exponent += inc;
                }
            }
        }
        NumberToString.nCreateStringFromNumberWithCheck(decimal, 10.0, mantissaReference);
        NumberToString.nCreateStringFromNumberWithCheck(exponent, 10.0, exponentReference);
        if (!isPositive) {
            result = strings.strAppendString(result, "-".toCharArray());
        }
        result = strings.strAppendString(result, mantissaReference.string);
        result = strings.strAppendString(result, "e".toCharArray());
        result = strings.strAppendString(result, exponentReference.string);
        return result;
    }

    public static char[] nCreateStringDecimalFromNumber(double decimal) {
        StringReference stringReference = new StringReference();
        NumberToString.nCreateStringFromNumberWithCheck(decimal, 10.0, stringReference);
        return stringReference.string;
    }

    public static boolean nCreateStringFromNumberWithCheck(double decimal, double base, StringReference stringReference) {
        boolean success;
        boolean isPositive = true;
        if (decimal < 0.0) {
            isPositive = false;
            decimal = -decimal;
        }
        if (decimal == 0.0) {
            stringReference.string = "0".toCharArray();
            success = true;
        } else {
            CharacterReference characterReference = new CharacterReference();
            if (math.IsInteger(base)) {
                double i;
                success = true;
                char[] string = new char[]{};
                double maximumDigits = NumberToString.nGetMaximumDigitsForBase(base);
                double digitPosition = NumberToString.nGetFirstDigitPosition(decimal, base);
                decimal = Math.round(decimal * Math.pow(base, maximumDigits - digitPosition - 1.0));
                boolean hasPrintedPoint = false;
                if (!isPositive) {
                    string = strings.strAppendCharacter(string, '-');
                }
                if (digitPosition < 0.0) {
                    string = strings.strAppendCharacter(string, '0');
                    string = strings.strAppendCharacter(string, '.');
                    hasPrintedPoint = true;
                    for (i = 0.0; i < -digitPosition - 1.0; i += 1.0) {
                        string = strings.strAppendCharacter(string, '0');
                    }
                }
                for (i = 0.0; i < maximumDigits && success; i += 1.0) {
                    double d = Math.floor(decimal / Math.pow(base, maximumDigits - i - 1.0));
                    if (d >= base) {
                        d = base - 1.0;
                    }
                    if (!hasPrintedPoint && digitPosition - i + 1.0 == 0.0) {
                        if (decimal != 0.0) {
                            string = strings.strAppendCharacter(string, '.');
                        }
                        hasPrintedPoint = true;
                    }
                    if ((decimal != 0.0 || !hasPrintedPoint) && (success = NumberToString.nGetSingleDigitCharacterFromNumberWithCheck(d, base, characterReference))) {
                        char c = characterReference.characterValue;
                        string = strings.strAppendCharacter(string, c);
                    }
                    if (!success) continue;
                    decimal -= d * Math.pow(base, maximumDigits - i - 1.0);
                }
                if (success) {
                    for (i = 0.0; i < digitPosition - maximumDigits + 1.0; i += 1.0) {
                        string = strings.strAppendCharacter(string, '0');
                    }
                    stringReference.string = string;
                }
            } else {
                success = false;
            }
        }
        return success;
    }

    public static double nGetMaximumDigitsForBase(double base) {
        double t = Math.pow(10.0, 15.0);
        return Math.floor(Math.log10(t) / Math.log10(base));
    }

    public static double nGetFirstDigitPosition(double decimal, double base) {
        double power = Math.ceil(Math.log10(decimal) / Math.log10(base));
        double t = decimal * Math.pow(base, -power);
        if (!(t < base) || !(t >= 1.0)) {
            if (t >= base) {
                power += 1.0;
            } else if (t < 1.0) {
                power -= 1.0;
            }
        }
        return power;
    }

    public static boolean nGetSingleDigitCharacterFromNumberWithCheck(double c, double base, CharacterReference characterReference) {
        boolean success;
        char[] numberTable = NumberToString.nGetDigitCharacterTable();
        if (c < base || c < (double)numberTable.length) {
            success = true;
            characterReference.characterValue = numberTable[(int)c];
        } else {
            success = false;
        }
        return success;
    }

    public static char[] nGetDigitCharacterTable() {
        char[] numberTable = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();
        return numberTable;
    }

    public static void delete(Object object) {
    }
}

