/*
 * Decompiled with CFR 0.152.
 */
package com.progsbase.libraries.JSON;

import JSON.StringElementMaps.StringElementMaps;
import JSON.json.json;
import JSON.structures.Element;
import JSON.writer.writer;
import com.progsbase.libraries.JSON.JSONException;
import com.progsbase.libraries.JSON.StringReturn;
import java.util.List;
import java.util.Map;

public class JSONObjectWriter {
    public static String writeJSON(Object object) {
        char[] value;
        try {
            Element e = JSONObjectWriter.unjavaifyJSONValue(object);
            value = writer.WriteJSON(e);
        }
        catch (JSONException ex) {
            value = "".toCharArray();
        }
        return new String(value);
    }

    public static String writeJSONExceptionOnFailure(Object o) throws JSONException {
        Element e = JSONObjectWriter.unjavaifyJSONValue(o);
        char[] value = writer.WriteJSON(e);
        return new String(value);
    }

    public static StringReturn writeJSONWithCheck(Object o) {
        StringReturn stringReturn = new StringReturn();
        try {
            Element e = JSONObjectWriter.unjavaifyJSONValue(o);
            stringReturn.success = true;
            stringReturn.errorMessage = "";
            stringReturn.str = new String(writer.WriteJSON(e));
        }
        catch (JSONException ex) {
            stringReturn.success = false;
            stringReturn.errorMessage = ex.getMessage();
            stringReturn.str = "";
        }
        return stringReturn;
    }

    public static Element unjavaifyJSONValue(Object o) throws JSONException {
        Element e;
        if (o == null) {
            e = json.CreateNullElement();
        } else if (o instanceof Map) {
            e = JSONObjectWriter.unjavaifyJSONObject(o);
        } else if (o.getClass().isArray()) {
            e = JSONObjectWriter.unjavaifyJSONArrayArray(o);
        } else if (o instanceof List) {
            e = JSONObjectWriter.unjavaifyJSONArrayList(o);
        } else if (o instanceof String) {
            String s = (String)o;
            e = json.CreateStringElement(s.toCharArray());
        } else if (o instanceof Double) {
            Double n = (Double)o;
            e = json.CreateNumberElement(n);
        } else if (o instanceof Float) {
            Float n = (Float)o;
            e = json.CreateNumberElement(n.floatValue());
        } else if (o instanceof Integer) {
            Integer n = (Integer)o;
            e = json.CreateNumberElement(n.intValue());
        } else if (o instanceof Long) {
            Long n = (Long)o;
            e = json.CreateNumberElement(n.longValue());
        } else if (o instanceof Short) {
            Short n = (Short)o;
            e = json.CreateNumberElement(n.shortValue());
        } else if (o instanceof Byte) {
            Byte n = (Byte)o;
            e = json.CreateNumberElement(n.byteValue());
        } else if (o instanceof Boolean) {
            Boolean b = (Boolean)o;
            e = json.CreateBooleanElement(b);
        } else {
            throw new JSONException("Cannot be converted to JSON structure: " + o.getClass());
        }
        return e;
    }

    public static Element unjavaifyJSONObject(Object o) throws JSONException {
        Map m = (Map)o;
        Element e = json.CreateObjectElement(m.size());
        int i = 0;
        for (Map.Entry p : m.entrySet()) {
            Element s = JSONObjectWriter.unjavaifyJSONValue(p.getValue());
            StringElementMaps.SetStringElementMap(e.object, i, ((String)p.getKey()).toCharArray(), s);
            ++i;
        }
        return e;
    }

    public static Element unjavaifyJSONArrayList(Object o) throws JSONException {
        List l = (List)o;
        Element e = json.CreateArrayElement(l.size());
        int i = 0;
        for (Object p : l) {
            Element s;
            e.array[i] = s = JSONObjectWriter.unjavaifyJSONValue(p);
            ++i;
        }
        return e;
    }

    public static Element unjavaifyJSONArrayArray(Object o) throws JSONException {
        Object[] a = (Object[])o;
        Element e = json.CreateArrayElement(a.length);
        int i = 0;
        for (Object p : a) {
            Element s;
            e.array[i] = s = JSONObjectWriter.unjavaifyJSONValue(p);
            ++i;
        }
        return e;
    }
}

