/*
 * Decompiled with CFR 0.152.
 */
package com.progsbase.libraries.JSON;

import JSON.StringElementMaps.StringElementMap;
import JSON.StringElementMaps.StringElementMaps;
import JSON.parser.parser;
import JSON.structures.Element;
import JSON.structures.ElementReference;
import com.progsbase.libraries.JSON.JSONException;
import com.progsbase.libraries.JSON.JSONReturn;
import java.util.ArrayList;
import java.util.HashMap;
import references.references.StringArrayReference;
import references.references.references;

public class JSONObjectReader {
    public static Object readJSON(String json2) {
        Object object = null;
        ElementReference elementReference = new ElementReference();
        StringArrayReference errorMessages = references.CreateStringArrayReferenceLengthValue(0.0, "".toCharArray());
        boolean success = parser.ReadJSON(json2.toCharArray(), elementReference, errorMessages);
        if (success) {
            object = JSONObjectReader.javaifyJSONValue(elementReference.element);
        }
        return object;
    }

    public static Object readJSONExceptionOnFailure(String json2) throws JSONException {
        ElementReference elementReference = new ElementReference();
        StringArrayReference errorMessages = references.CreateStringArrayReferenceLengthValue(0.0, "".toCharArray());
        boolean success = parser.ReadJSON(json2.toCharArray(), elementReference, errorMessages);
        if (!success) {
            String errorMessage = JSONObjectReader.joinErrorMessages(errorMessages);
            throw new JSONException(errorMessage);
        }
        Object object = JSONObjectReader.javaifyJSONValue(elementReference.element);
        return object;
    }

    public static String joinErrorMessages(StringArrayReference errorMessages) {
        StringBuilder errorMessage = new StringBuilder();
        for (int i = 0; i < errorMessages.stringArray.length; ++i) {
            errorMessage.append(i + 1);
            errorMessage.append(". ");
            errorMessage.append(new String(errorMessages.stringArray[i].string));
            errorMessage.append(" ");
        }
        return errorMessage.toString();
    }

    public static JSONReturn readJSONWithCheck(String json2) {
        Object object = null;
        JSONReturn jsonReturn = new JSONReturn();
        ElementReference elementReference = new ElementReference();
        StringArrayReference errorMessages = references.CreateStringArrayReferenceLengthValue(0.0, "".toCharArray());
        boolean success = parser.ReadJSON(json2.toCharArray(), elementReference, errorMessages);
        if (success) {
            object = JSONObjectReader.javaifyJSONValue(elementReference.element);
        } else {
            jsonReturn.errorMessage = JSONObjectReader.joinErrorMessages(errorMessages);
        }
        jsonReturn.object = object;
        jsonReturn.success = success;
        return jsonReturn;
    }

    public static Object javaifyJSONValue(Element element) {
        Object o = null;
        String type = new String(element.type);
        if (type.equals("object")) {
            o = JSONObjectReader.javaifyJSONObject(element.object);
        } else if (type.equals("array")) {
            o = JSONObjectReader.javaifyJSONArray(element.array);
        } else if (type.equals("string")) {
            o = new String(element.string);
        } else if (type.equals("number")) {
            o = element.number;
        } else if (type.equals("boolean")) {
            o = element.booleanValue;
        } else if (type.equals("null")) {
            o = null;
        }
        return o;
    }

    public static Object javaifyJSONObject(StringElementMap object) {
        HashMap<String, Object> resultObject = new HashMap<String, Object>();
        int i = 0;
        while ((double)i < StringElementMaps.GetStringElementMapNumberOfKeys(object)) {
            resultObject.put(new String(object.stringListRef.stringArray[i].string), JSONObjectReader.javaifyJSONValue(object.elementListRef.array[i]));
            ++i;
        }
        return resultObject;
    }

    public static Object javaifyJSONArray(Element[] array) {
        ArrayList<Object> resultArray = new ArrayList<Object>();
        for (int i = 0; i < array.length; ++i) {
            resultArray.add(JSONObjectReader.javaifyJSONValue(array[i]));
        }
        return resultArray;
    }
}

