/*
 * Decompiled with CFR 0.152.
 */
package JSON.tokenReader;

import arrays.arrays.arrays;
import charCharacters.Characters.Characters;
import lists.LinkedListStrings.LinkedListStringsFunctions.LinkedListStringsFunctions;
import lists.LinkedListStrings.Structures.LinkedListStrings;
import lists.StringList.StringList;
import nnumbers.StringToNumber.StringToNumber;
import references.references.NumberReference;
import references.references.StringArrayReference;
import references.references.StringReference;
import references.references.references;
import strstrings.strings.strings;

public class tokenReader {
    public static boolean JSONTokenize(char[] json2, StringArrayReference tokensReference, StringArrayReference errorMessages) {
        LinkedListStrings ll = LinkedListStringsFunctions.CreateLinkedListString();
        boolean success = true;
        NumberReference stringLength = new NumberReference();
        StringReference tokenReference = new StringReference();
        double i = 0.0;
        while (i < (double)json2.length && success) {
            char c = json2[(int)i];
            if (c == '{') {
                LinkedListStringsFunctions.LinkedListAddString(ll, "{".toCharArray());
                i += 1.0;
                continue;
            }
            if (c == '}') {
                LinkedListStringsFunctions.LinkedListAddString(ll, "}".toCharArray());
                i += 1.0;
                continue;
            }
            if (c == '[') {
                LinkedListStringsFunctions.LinkedListAddString(ll, "[".toCharArray());
                i += 1.0;
                continue;
            }
            if (c == ']') {
                LinkedListStringsFunctions.LinkedListAddString(ll, "]".toCharArray());
                i += 1.0;
                continue;
            }
            if (c == ':') {
                LinkedListStringsFunctions.LinkedListAddString(ll, ":".toCharArray());
                i += 1.0;
                continue;
            }
            if (c == ',') {
                LinkedListStringsFunctions.LinkedListAddString(ll, ",".toCharArray());
                i += 1.0;
                continue;
            }
            if (c == 'f') {
                success = tokenReader.GetJSONPrimitiveName(json2, i, errorMessages, "false".toCharArray(), tokenReference);
                if (!success) continue;
                LinkedListStringsFunctions.LinkedListAddString(ll, "false".toCharArray());
                i += (double)"false".toCharArray().length;
                continue;
            }
            if (c == 't') {
                success = tokenReader.GetJSONPrimitiveName(json2, i, errorMessages, "true".toCharArray(), tokenReference);
                if (!success) continue;
                LinkedListStringsFunctions.LinkedListAddString(ll, "true".toCharArray());
                i += (double)"true".toCharArray().length;
                continue;
            }
            if (c == 'n') {
                success = tokenReader.GetJSONPrimitiveName(json2, i, errorMessages, "null".toCharArray(), tokenReference);
                if (!success) continue;
                LinkedListStringsFunctions.LinkedListAddString(ll, "null".toCharArray());
                i += (double)"null".toCharArray().length;
                continue;
            }
            if (c == ' ' || c == '\n' || c == '\t' || c == '\r') {
                i += 1.0;
                continue;
            }
            if (c == '\"') {
                success = tokenReader.GetJSONString(json2, i, tokenReference, stringLength, errorMessages);
                if (!success) continue;
                LinkedListStringsFunctions.LinkedListAddString(ll, tokenReference.string);
                i += stringLength.numberValue;
                continue;
            }
            if (tokenReader.IsJSONNumberCharacter(c)) {
                success = tokenReader.GetJSONNumberToken(json2, i, tokenReference, errorMessages);
                if (!success) continue;
                LinkedListStringsFunctions.LinkedListAddString(ll, tokenReference.string);
                i += (double)tokenReference.string.length;
                continue;
            }
            char[] str = strings.strConcatenateCharacter("Invalid start of Token: ".toCharArray(), c);
            StringReference stringReference = references.CreateStringReference(str);
            StringList.AddStringRef(errorMessages, stringReference);
            i += 1.0;
            success = false;
        }
        if (success) {
            LinkedListStringsFunctions.LinkedListAddString(ll, "<end>".toCharArray());
            tokensReference.stringArray = LinkedListStringsFunctions.LinkedListStringsToArray(ll);
            LinkedListStringsFunctions.FreeLinkedListString(ll);
        }
        return success;
    }

    public static boolean GetJSONNumberToken(char[] json2, double start, StringReference tokenReference, StringArrayReference errorMessages) {
        double end = json2.length;
        boolean done = false;
        for (double i = start; i < (double)json2.length && !done; i += 1.0) {
            char c = json2[(int)i];
            if (tokenReader.IsJSONNumberCharacter(c)) continue;
            done = true;
            end = i;
        }
        char[] numberString = strings.strSubstring(json2, start, end);
        boolean success = tokenReader.IsValidJSONNumber(numberString, errorMessages);
        tokenReference.string = numberString;
        return success;
    }

    public static boolean IsValidJSONNumber(char[] n, StringArrayReference errorMessages) {
        boolean success;
        double i = 0.0;
        if (n[(int)i] == '-') {
            i += 1.0;
        }
        if (i < (double)n.length) {
            success = tokenReader.IsValidJSONNumberAfterSign(n, i, errorMessages);
        } else {
            success = false;
            StringList.AddStringRef(errorMessages, references.CreateStringReference("Number must contain at least one digit.".toCharArray()));
        }
        return success;
    }

    public static boolean IsValidJSONNumberAfterSign(char[] n, double i, StringArrayReference errorMessages) {
        boolean success;
        if (Characters.charIsNumber(n[(int)i])) {
            i = n[(int)i] == '0' ? (i += 1.0) : tokenReader.IsValidJSONNumberAdvancePastDigits(n, i);
            success = i < (double)n.length ? tokenReader.IsValidJSONNumberFromDotOrExponent(n, i, errorMessages) : true;
        } else {
            success = false;
            StringList.AddStringRef(errorMessages, references.CreateStringReference("A number must start with 0-9 (after the optional sign).".toCharArray()));
        }
        return success;
    }

    public static double IsValidJSONNumberAdvancePastDigits(char[] n, double i) {
        i += 1.0;
        boolean done = false;
        while (i < (double)n.length && !done) {
            if (Characters.charIsNumber(n[(int)i])) {
                i += 1.0;
                continue;
            }
            done = true;
        }
        return i;
    }

    public static boolean IsValidJSONNumberFromDotOrExponent(char[] n, double i, StringArrayReference errorMessages) {
        boolean wasDotAndOrE = false;
        boolean success = true;
        if (n[(int)i] == '.') {
            i += 1.0;
            wasDotAndOrE = true;
            if (i < (double)n.length) {
                if (Characters.charIsNumber(n[(int)i])) {
                    if ((i = tokenReader.IsValidJSONNumberAdvancePastDigits(n, i)) == (double)n.length) {
                        success = true;
                    }
                } else {
                    success = false;
                    StringList.AddStringRef(errorMessages, references.CreateStringReference("There must be numbers after the decimal point.".toCharArray()));
                }
            } else {
                success = false;
                StringList.AddStringRef(errorMessages, references.CreateStringReference("There must be numbers after the decimal point.".toCharArray()));
            }
        }
        if (i < (double)n.length && success) {
            if (n[(int)i] == 'e' || n[(int)i] == 'E') {
                wasDotAndOrE = true;
                success = tokenReader.IsValidJSONNumberFromExponent(n, i, errorMessages);
            } else {
                success = false;
                StringList.AddStringRef(errorMessages, references.CreateStringReference("Expected e or E.".toCharArray()));
            }
        } else if (i == (double)n.length && success) {
            success = true;
        } else {
            success = false;
            StringList.AddStringRef(errorMessages, references.CreateStringReference("There must be numbers after the decimal point.".toCharArray()));
        }
        if (!wasDotAndOrE) {
            success = false;
            StringList.AddStringRef(errorMessages, references.CreateStringReference("Exprected decimal point or e or E.".toCharArray()));
        }
        return success;
    }

    public static boolean IsValidJSONNumberFromExponent(char[] n, double i, StringArrayReference errorMessages) {
        boolean success;
        if ((i += 1.0) < (double)n.length) {
            if (n[(int)i] == '+' || n[(int)i] == '-') {
                i += 1.0;
            }
            if (i < (double)n.length) {
                if (Characters.charIsNumber(n[(int)i])) {
                    if ((i = tokenReader.IsValidJSONNumberAdvancePastDigits(n, i)) == (double)n.length) {
                        success = true;
                    } else {
                        success = false;
                        StringList.AddStringRef(errorMessages, references.CreateStringReference("There was characters following the exponent.".toCharArray()));
                    }
                } else {
                    success = false;
                    StringList.AddStringRef(errorMessages, references.CreateStringReference("There must be a digit following the optional exponent sign.".toCharArray()));
                }
            } else {
                success = false;
                StringList.AddStringRef(errorMessages, references.CreateStringReference("There must be a digit following optional the exponent sign.".toCharArray()));
            }
        } else {
            success = false;
            StringList.AddStringRef(errorMessages, references.CreateStringReference("There must be a sign or a digit following e or E.".toCharArray()));
        }
        return success;
    }

    public static boolean IsJSONNumberCharacter(char c) {
        char[] numericCharacters = "0123456789.-+eE".toCharArray();
        boolean found = false;
        for (double i = 0.0; i < (double)numericCharacters.length; i += 1.0) {
            if (numericCharacters[(int)i] != c) continue;
            found = true;
        }
        return found;
    }

    public static boolean GetJSONPrimitiveName(char[] string, double start, StringArrayReference errorMessages, char[] primitive, StringReference tokenReference) {
        boolean done = false;
        boolean success = true;
        char[] token = "".toCharArray();
        for (double i = start; i < (double)string.length && i - start < (double)primitive.length && !done; i += 1.0) {
            char c = string[(int)i];
            char p = primitive[(int)(i - start)];
            if (c == p) {
                if (i + 1.0 - start != (double)primitive.length) continue;
                done = true;
                continue;
            }
            char[] str = "".toCharArray();
            str = strings.strConcatenateString(str, "Primitive invalid: ".toCharArray());
            str = strings.strAppendCharacter(str, c);
            str = strings.strAppendString(str, " vs ".toCharArray());
            str = strings.strAppendCharacter(str, p);
            StringList.AddStringRef(errorMessages, references.CreateStringReference(str));
            done = true;
            success = false;
        }
        if (done) {
            if (arrays.StringsEqual(primitive, "false".toCharArray())) {
                token = "false".toCharArray();
            }
            if (arrays.StringsEqual(primitive, "true".toCharArray())) {
                token = "true".toCharArray();
            }
            if (arrays.StringsEqual(primitive, "null".toCharArray())) {
                token = "null".toCharArray();
            }
        } else {
            StringList.AddStringRef(errorMessages, references.CreateStringReference("Primitive invalid".toCharArray()));
            success = false;
        }
        tokenReference.string = token;
        return success;
    }

    public static boolean GetJSONString(char[] json2, double start, StringReference tokenReference, NumberReference stringLengthReference, StringArrayReference errorMessages) {
        NumberReference characterCount = references.CreateNumberReference(0.0);
        char[] hex = arrays.CreateString(4.0, '0');
        NumberReference hexReference = new NumberReference();
        StringReference errorMessage = new StringReference();
        boolean success = tokenReader.IsValidJSONStringInJSON(json2, start, characterCount, stringLengthReference, errorMessages);
        if (success) {
            double l = characterCount.numberValue;
            char[] string = new char[(int)l];
            double c = 0.0;
            string[(int)c] = 34;
            c += 1.0;
            boolean done = false;
            double i = start + 1.0;
            while (!done) {
                if (json2[(int)i] == '\\') {
                    if (json2[(int)(i += 1.0)] == '\"' || json2[(int)i] == '\\' || json2[(int)i] == '/') {
                        string[(int)c] = json2[(int)i];
                        c += 1.0;
                    } else if (json2[(int)i] == 'b') {
                        string[(int)c] = 8;
                        c += 1.0;
                    } else if (json2[(int)i] == 'f') {
                        string[(int)c] = 12;
                        c += 1.0;
                    } else if (json2[(int)i] == 'n') {
                        string[(int)c] = 10;
                        c += 1.0;
                    } else if (json2[(int)i] == 'r') {
                        string[(int)c] = 13;
                        c += 1.0;
                    } else if (json2[(int)i] == 't') {
                        string[(int)c] = 9;
                        c += 1.0;
                    } else if (json2[(int)i] == 'u') {
                        hex[0] = Characters.charToUpperCase(json2[(int)((i += 1.0) + 0.0)]);
                        hex[1] = Characters.charToUpperCase(json2[(int)(i + 1.0)]);
                        hex[2] = Characters.charToUpperCase(json2[(int)(i + 2.0)]);
                        hex[3] = Characters.charToUpperCase(json2[(int)(i + 3.0)]);
                        StringToNumber.nCreateNumberFromStringWithCheck(hex, 16.0, hexReference, errorMessage);
                        string[(int)c] = (char)hexReference.numberValue;
                        i += 3.0;
                        c += 1.0;
                    }
                } else if (json2[(int)i] == '\"') {
                    string[(int)c] = json2[(int)i];
                    c += 1.0;
                    done = true;
                } else {
                    string[(int)c] = json2[(int)i];
                    c += 1.0;
                }
                i += 1.0;
            }
            tokenReference.string = string;
            success = true;
        } else {
            StringList.AddStringRef(errorMessages, references.CreateStringReference("End of string was not found.".toCharArray()));
            success = false;
        }
        return success;
    }

    public static boolean IsValidJSONString(char[] jsonString, StringArrayReference errorMessages) {
        NumberReference numberReference = new NumberReference();
        NumberReference stringLength = new NumberReference();
        boolean valid = tokenReader.IsValidJSONStringInJSON(jsonString, 0.0, numberReference, stringLength, errorMessages);
        return valid;
    }

    public static boolean IsValidJSONStringInJSON(char[] json2, double start, NumberReference characterCount, NumberReference stringLengthReference, StringArrayReference errorMessages) {
        double i;
        boolean success = true;
        boolean done = false;
        characterCount.numberValue = 1.0;
        for (i = start + 1.0; i < (double)json2.length && !done && success; i += 1.0) {
            if (!tokenReader.IsJSONIllegalControllCharacter(json2[(int)i])) {
                if (json2[(int)i] == '\\') {
                    if ((i += 1.0) < (double)json2.length) {
                        if (json2[(int)i] == '\"' || json2[(int)i] == '\\' || json2[(int)i] == '/' || json2[(int)i] == 'b' || json2[(int)i] == 'f' || json2[(int)i] == 'n' || json2[(int)i] == 'r' || json2[(int)i] == 't') {
                            characterCount.numberValue += 1.0;
                            continue;
                        }
                        if (json2[(int)i] == 'u') {
                            if (i + 4.0 < (double)json2.length) {
                                for (double j = 0.0; j < 4.0 && success; j += 1.0) {
                                    char c = json2[(int)(i + j + 1.0)];
                                    if (StringToNumber.nCharacterIsNumberCharacterInBase(c, 16.0) || c == 'a' || c == 'b' || c == 'c' || c == 'd' || c == 'e' || c == 'f') continue;
                                    success = false;
                                    StringList.AddStringRef(errorMessages, references.CreateStringReference("\\u must be followed by four hexadecimal digits.".toCharArray()));
                                }
                                characterCount.numberValue += 1.0;
                                i += 4.0;
                                continue;
                            }
                            success = false;
                            StringList.AddStringRef(errorMessages, references.CreateStringReference("\\u must be followed by four characters.".toCharArray()));
                            continue;
                        }
                        success = false;
                        StringList.AddStringRef(errorMessages, references.CreateStringReference("Escaped character invalid.".toCharArray()));
                        continue;
                    }
                    success = false;
                    StringList.AddStringRef(errorMessages, references.CreateStringReference("There must be at least two character after string escape.".toCharArray()));
                    continue;
                }
                if (json2[(int)i] == '\"') {
                    characterCount.numberValue += 1.0;
                    done = true;
                    continue;
                }
                characterCount.numberValue += 1.0;
                continue;
            }
            success = false;
            StringList.AddStringRef(errorMessages, references.CreateStringReference("Unicode code points 0-31 not allowed in JSON string.".toCharArray()));
        }
        if (done) {
            stringLengthReference.numberValue = i - start;
        } else {
            success = false;
            StringList.AddStringRef(errorMessages, references.CreateStringReference("String must end with \".".toCharArray()));
        }
        return success;
    }

    public static boolean IsJSONIllegalControllCharacter(char c) {
        double cnr = c;
        boolean isControll = cnr >= 0.0 && cnr < 32.0;
        return isControll;
    }
}

