/*
 * Decompiled with CFR 0.152.
 */
package net.praqma.prqa.status;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import net.praqma.prqa.PRQAReading;
import net.praqma.prqa.exceptions.PrqaException;
import net.praqma.prqa.exceptions.PrqaReadingException;
import net.praqma.prqa.status.StatusCategory;

public abstract class PRQAStatus
implements PRQAReading,
Serializable {
    private static final long serialVersionUID = 1L;
    protected List<String> notifications = new ArrayList<String>();
    protected HashMap<StatusCategory, Number> thresholds;
    protected static final Logger logger = Logger.getLogger(PRQAStatus.class.getName());

    @Override
    public void addNotification(String message) {
        logger.finest("Starting execution of method - addNotification");
        logger.finest(String.format("Input parameter message type: %s; value: %s", message.getClass(), message));
        this.notifications.add(message);
        logger.finest("Ending execution of method - addNotification");
    }

    @Override
    public HashMap<StatusCategory, Number> getThresholds() {
        if (this.thresholds != null) {
            logger.finest("Starting execution of method - getThresholds");
            logger.finest("Returning HashMap<StatusCategory, Number> thresholds:");
            for (Map.Entry<StatusCategory, Number> entry : this.thresholds.entrySet()) {
                logger.finest(String.format("    StatusCategory: %s, Number: %s", new Object[]{entry.getKey(), entry.getValue()}));
            }
            return this.thresholds;
        }
        return new HashMap<StatusCategory, Number>();
    }

    @Override
    public void setThresholds(HashMap<StatusCategory, Number> thresholds) {
        logger.finest("Starting execution of method - setThresholds");
        logger.finest(String.format("Input parameter thresholds type: %s, values:", thresholds.getClass()));
        for (Map.Entry<StatusCategory, Number> entry : thresholds.entrySet()) {
            logger.finest(String.format("    StatusCategory: %s, Number: %s", new Object[]{entry.getKey(), entry.getValue()}));
        }
        this.thresholds = thresholds;
        logger.finest("Ending execution of method - setThresholds");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public HashMap<StatusCategory, Number> getReadouts(StatusCategory ... categories) throws PrqaException {
        void var4_6;
        logger.finest("Starting execution of method - getReadouts");
        StatusCategory[] statusCategoryArray = categories;
        int n = statusCategoryArray.length;
        boolean bl = false;
        while (var4_6 < n) {
            StatusCategory category = statusCategoryArray[var4_6];
            logger.finest(String.format("    %s", new Object[]{category}));
            ++var4_6;
        }
        logger.finest("Attempting to get readouts...");
        HashMap<StatusCategory, Number> map = new HashMap<StatusCategory, Number>();
        for (StatusCategory category : categories) {
            try {
                Number readout = this.getReadout(category);
                map.put(category, readout);
            }
            catch (PrqaReadingException ex) {
                logger.severe(String.format("Exception thrown type: %s; message: %s", ex.getClass(), ex.getMessage()));
                throw ex;
            }
        }
        logger.finest("Successfully got all readouts!");
        logger.finest("Returning HashMap<StatusCategory, Number> map:");
        for (Map.Entry entry : map.entrySet()) {
            logger.finest(String.format("    StatusCategory: %s, Number: %s", entry.getKey(), entry.getValue()));
        }
        return map;
    }

    public abstract boolean isValid();

    public abstract String toHtml();
}

