/*
 * Decompiled with CFR 0.152.
 */
package net.praqma.jenkins.plugin.prqa.notifier;

import hudson.model.Descriptor;
import hudson.util.FormValidation;
import net.praqma.jenkins.plugin.prqa.notifier.Messages;
import net.praqma.jenkins.plugin.prqa.threshold.AbstractThreshold;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public abstract class ThresholdSelectionDescriptor<T extends AbstractThreshold>
extends Descriptor<AbstractThreshold> {
    public AbstractThreshold newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
        return (AbstractThreshold)super.newInstance(req, formData);
    }

    public FormValidation doCheckValue(@QueryParameter String value, @QueryParameter boolean improvement) {
        if (!improvement) {
            try {
                Double parsedValue = Double.parseDouble(value);
                if (parsedValue < 0.0) {
                    return FormValidation.error((String)Messages.PRQANotifier_WrongDecimalValue());
                }
            }
            catch (NumberFormatException ex) {
                return FormValidation.error((String)Messages.PRQANotifier_WrongDecimalPunctuation());
            }
        }
        return FormValidation.ok();
    }
}

