/*
 * Decompiled with CFR 0.152.
 */
package net.praqma.jenkins.plugin.prqa;

import hudson.model.BuildListener;
import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import jenkins.MasterToSlaveFileCallable;
import net.praqma.prqa.PRQAApplicationSettings;
import net.praqma.prqa.ReportSettings;
import net.praqma.prqa.exceptions.PrqaSetupException;
import net.praqma.prqa.products.Product;

public class PRQARemoteToolCheck
extends MasterToSlaveFileCallable<String> {
    public final BuildListener listener;
    public final boolean isUnix;
    public HashMap<String, String> environment;
    public final PRQAApplicationSettings appSettings;
    public final ReportSettings reportSettings;
    public final Product product;
    public static final String PATH = "Path";

    public PRQARemoteToolCheck(Product product, HashMap<String, String> environment, PRQAApplicationSettings appSettings, ReportSettings reportSettings, BuildListener listener, boolean isUnix) {
        this.listener = listener;
        this.isUnix = isUnix;
        this.environment = environment;
        this.appSettings = appSettings;
        this.reportSettings = reportSettings;
        this.product = product;
    }

    private static Map<String, String> expandEnvironment(Map<String, String> environment) throws PrqaSetupException {
        if (environment == null) {
            return Collections.emptyMap();
        }
        String delimiter = System.getProperty("file.separator");
        environment.put("QAFBINPATH", PRQAApplicationSettings.addSlash(environment.get("QAFINSTALLPATH"), delimiter) + "common" + delimiter + "bin");
        return environment;
    }

    public String invoke(File f, VirtualChannel channel) throws IOException, InterruptedException {
        try {
            Map<String, String> envExpanded = PRQARemoteToolCheck.expandEnvironment(this.environment);
            return this.product.getProductVersion(envExpanded, f, this.isUnix);
        }
        catch (PrqaSetupException setupException) {
            throw new IOException("Tool misconfiguration detected", setupException);
        }
    }
}

