/*
 * Decompiled with CFR 0.152.
 */
package com.profesorfalken.jpowershell;

import com.profesorfalken.jpowershell.PowerShellCommandProcessor;
import com.profesorfalken.jpowershell.PowerShellNotAvailableException;
import com.profesorfalken.jpowershell.PowerShellResponse;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PowerShell {
    private static final String CRLF = "\r\n";
    private Process p;
    private PrintWriter commandWriter;
    private boolean closed = false;
    private ExecutorService threadpool;
    private static final int MAX_THREADS = 3;
    static final int WAIT_PAUSE = 10;
    static final int MAX_WAIT = 5000;

    private PowerShell() {
    }

    private PowerShell initalize() throws PowerShellNotAvailableException {
        ProcessBuilder pb = new ProcessBuilder("powershell.exe", "-NoExit", "-Command", "-");
        try {
            this.p = pb.start();
        }
        catch (IOException ex) {
            throw new PowerShellNotAvailableException("Cannot execute PowerShell.exe. Please make sure that it is installed in your system", ex);
        }
        this.commandWriter = new PrintWriter((Writer)new OutputStreamWriter(new BufferedOutputStream(this.p.getOutputStream())), true);
        this.threadpool = Executors.newFixedThreadPool(3);
        return this;
    }

    public static PowerShell openSession() throws PowerShellNotAvailableException {
        PowerShell powerShell = new PowerShell();
        return powerShell.initalize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PowerShellResponse executeCommand(String command) {
        PowerShellCommandProcessor commandProcessor = new PowerShellCommandProcessor("standard", this.commandWriter, this.p.getInputStream());
        PowerShellCommandProcessor commandProcessorError = new PowerShellCommandProcessor("error", this.commandWriter, this.p.getErrorStream());
        String commandOutput = "";
        boolean isError = false;
        Future result = this.threadpool.submit(commandProcessor);
        Future resultError = this.threadpool.submit(commandProcessorError);
        this.commandWriter.println(command);
        try {
            while (!result.isDone() && !resultError.isDone()) {
                Thread.sleep(10L);
            }
            if (result.isDone()) {
                commandOutput = (String)result.get();
            } else {
                isError = true;
                commandOutput = (String)resultError.get();
            }
        }
        catch (InterruptedException ex) {
            Logger.getLogger(PowerShell.class.getName()).log(Level.SEVERE, "Unexpected error when processing PowerShell command", ex);
        }
        catch (ExecutionException ex) {
            Logger.getLogger(PowerShell.class.getName()).log(Level.SEVERE, "Unexpected error when processing PowerShell command", ex);
        }
        finally {
            commandProcessor.close();
            commandProcessorError.close();
        }
        return new PowerShellResponse(isError, commandOutput);
    }

    public void close() {
        if (!this.closed) {
            try {
                Future<String> closeTask = this.threadpool.submit(new Callable<String>(){

                    @Override
                    public String call() throws Exception {
                        PowerShell.this.commandWriter.println("exit");
                        PowerShell.this.p.waitFor();
                        return "OK";
                    }
                });
                int closingTime = 0;
                while (!closeTask.isDone() && !closeTask.isDone()) {
                    if (closingTime > 5000) {
                        Logger.getLogger(PowerShell.class.getName()).log(Level.SEVERE, "Unexpected error when closing PowerShell: TIMEOUT!");
                        break;
                    }
                    Thread.sleep(10L);
                    closingTime += 10;
                }
            }
            catch (InterruptedException ex) {
                Logger.getLogger(PowerShell.class.getName()).log(Level.SEVERE, "Unexpected error when when closing PowerShell", ex);
            }
            finally {
                this.commandWriter.close();
                if (this.threadpool != null) {
                    this.threadpool.shutdownNow();
                    while (!this.threadpool.isTerminated()) {
                    }
                }
                this.closed = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PowerShellResponse executeSingleCommand(String command) {
        PowerShell session = null;
        PowerShellResponse response = null;
        try {
            session = PowerShell.openSession();
            response = session.executeCommand(command);
        }
        catch (PowerShellNotAvailableException ex) {
            Logger.getLogger(PowerShell.class.getName()).log(Level.SEVERE, "PowerShell not available", ex);
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
        return response;
    }

    protected void finalize() throws Throwable {
        if (!this.closed) {
            Logger.getLogger(PowerShell.class.getName()).log(Level.WARNING, "Finalize executed because Powershell session was not properly closed!");
            this.close();
        }
        super.finalize();
    }
}

