/*
 * Decompiled with CFR 0.152.
 */
package com.profesorfalken.jpowershell;

import com.profesorfalken.jpowershell.PowerShellCommandProcessor;
import com.profesorfalken.jpowershell.PowerShellNotAvailableException;
import com.profesorfalken.jpowershell.PowerShellResponse;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PowerShell {
    private Process p;
    private PrintWriter commandWriter;
    private boolean closed = false;
    private ExecutorService threadpool;
    private static final int MAX_THREADS = 3;

    private PowerShell() {
    }

    private PowerShell initalize() throws PowerShellNotAvailableException {
        ProcessBuilder pb = new ProcessBuilder("powershell.exe", "-NoExit", "-Command", "-");
        try {
            this.p = pb.start();
        }
        catch (IOException ex) {
            throw new PowerShellNotAvailableException("Cannot execute PowerShell.exe. Either your are not using a Windows system or PowerShell is not installed", ex);
        }
        this.commandWriter = new PrintWriter((Writer)new OutputStreamWriter(new BufferedOutputStream(this.p.getOutputStream())), true);
        return this;
    }

    public static PowerShell openSession() throws PowerShellNotAvailableException {
        PowerShell powerShell = new PowerShell();
        return powerShell.initalize();
    }

    public PowerShellResponse executeCommand(String command) {
        PowerShellCommandProcessor commandProcessor = new PowerShellCommandProcessor(this.commandWriter, this.p.getInputStream());
        PowerShellCommandProcessor commandProcessorError = new PowerShellCommandProcessor(this.commandWriter, this.p.getErrorStream());
        String commandOutput = "";
        boolean isError = false;
        this.threadpool = Executors.newFixedThreadPool(3);
        Future result = this.threadpool.submit(commandProcessor);
        Future resultError = this.threadpool.submit(commandProcessorError);
        this.commandWriter.println(command);
        try {
            while (!result.isDone() && !resultError.isDone()) {
                Thread.sleep(50L);
            }
            if (result.isDone()) {
                commandOutput = (String)result.get();
            } else {
                isError = true;
                commandOutput = (String)resultError.get();
            }
        }
        catch (InterruptedException ex) {
            Logger.getLogger(PowerShell.class.getName()).log(Level.SEVERE, "Unexpected error when processing PowerShell command", ex);
        }
        catch (ExecutionException ex) {
            Logger.getLogger(PowerShell.class.getName()).log(Level.SEVERE, "Unexpected error when processing PowerShell command", ex);
        }
        return new PowerShellResponse(isError, commandOutput);
    }

    public void close() {
        try {
            this.commandWriter.println("exit");
            try {
                this.p.waitFor();
            }
            catch (InterruptedException ex) {
                Logger.getLogger(PowerShell.class.getName()).log(Level.SEVERE, "Unexpected error when processing PowerShell command", ex);
            }
        }
        finally {
            this.commandWriter.close();
            this.threadpool.shutdown();
            this.closed = true;
        }
    }

    protected void finalize() throws Throwable {
        if (!this.closed) {
            this.close();
        }
        super.finalize();
    }
}

