/*
 * Decompiled with CFR 0.152.
 */
package com.pro_crafting.tools.jasperreport;

import com.pro_crafting.tools.jasperreport.JasperMojoConfiguration;
import com.pro_crafting.tools.jasperreport.JasperReportCompiler;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mojo(defaultPhase=LifecyclePhase.PROCESS_RESOURCES, name="jasper", requiresDependencyResolution=ResolutionScope.COMPILE, threadSafe=true)
public class JasperMojo
extends AbstractMojo {
    private static final Logger LOGGER = LoggerFactory.getLogger(JasperMojo.class);
    @Parameter(defaultValue="net.sf.jasperreports.engine.design.JRJdtCompiler")
    private String compiler;
    @Parameter(defaultValue="${project.build.outputDirectory}/jasper")
    private File outputDirectory;
    @Parameter(defaultValue="src/main/jasperreports")
    private File sourceDirectory;
    @Parameter(defaultValue=".jrxml")
    private String sourceFileExt;
    @Parameter(defaultValue=".jasper")
    private String outputFileExt;
    @Parameter(defaultValue="true")
    private boolean xmlValidation;
    @Parameter(defaultValue="false")
    private boolean skip;
    @Parameter(defaultValue="false")
    private boolean verbose;
    @Parameter(defaultValue="4")
    private int numberOfThreads;
    @Parameter(property="project.compileClasspathElements")
    private List<String> classpathElements;
    @Parameter
    private Map<String, String> additionalProperties;
    @Parameter(defaultValue="true")
    private boolean failOnMissingSourceDirectory;
    @Parameter(defaultValue="org.codehaus.plexus.compiler.util.scan.StaleSourceScanner")
    private String sourceScanner;
    @Parameter
    private String additionalClasspath;

    public void execute() throws MojoExecutionException {
        JasperMojoConfiguration configuration = this.mapConfiguration();
        if (this.verbose) {
            this.logConfiguration(configuration);
        }
        new JasperReportCompiler(configuration).compileReports();
    }

    JasperMojoConfiguration mapConfiguration() {
        JasperMojoConfiguration configuration = new JasperMojoConfiguration();
        configuration.compiler = this.compiler;
        configuration.outputDirectory = this.outputDirectory;
        configuration.sourceDirectory = this.sourceDirectory;
        configuration.sourceFileExt = this.sourceFileExt;
        configuration.outputFileExt = this.outputFileExt;
        configuration.xmlValidation = this.xmlValidation;
        configuration.skip = this.skip;
        configuration.verbose = this.verbose;
        configuration.numberOfThreads = this.numberOfThreads;
        configuration.classpathElements = this.classpathElements;
        configuration.additionalProperties = this.additionalProperties;
        configuration.failOnMissingSourceDirectory = this.failOnMissingSourceDirectory;
        configuration.sourceScanner = this.sourceScanner;
        configuration.additionalClasspath = this.additionalClasspath;
        return configuration;
    }

    private void logConfiguration(JasperMojoConfiguration configuration) {
        LOGGER.info("Generating Jasper reports");
        LOGGER.info("Output dir: {}", (Object)configuration.outputDirectory.getAbsolutePath());
        LOGGER.info("Source dir: {}", (Object)configuration.sourceDirectory.getAbsolutePath());
        LOGGER.info("Output ext: {}", (Object)configuration.outputFileExt);
        LOGGER.info("Source ext: {}", (Object)configuration.sourceFileExt);
        LOGGER.info("Additional properties: {}", configuration.additionalProperties);
        LOGGER.info("XML Validation: {}", (Object)configuration.xmlValidation);
        LOGGER.info("JasperReports Compiler: {}", (Object)configuration.compiler);
        LOGGER.info("Number of threads: {}", (Object)configuration.numberOfThreads);
        LOGGER.info("classpathElements: {}", configuration.classpathElements);
        LOGGER.info("Additional Classpath: {}", (Object)configuration.additionalClasspath);
        LOGGER.info("Source Scanner: {}", (Object)configuration.sourceScanner);
    }
}

