/*
 * Decompiled with CFR 0.152.
 */
package com.premiumminds.webapp.utils;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import javax.servlet.ServletContext;

public class WebAppFileLoader {
    private String filename;
    private ServletContext context;
    private static final String CONTEXT_SCHEME = "context";
    private static final String FILESYSTEM_SCHEME = "filesystem";
    private static final String CLASSPATH_SCHEME = "classpath";

    public WebAppFileLoader(String filename, ServletContext context) {
        this.filename = filename;
        this.context = context;
    }

    public WebAppFileLoader(String filename) {
        this(filename, null);
    }

    public InputStream load() throws URISyntaxException, FileNotFoundException {
        URI uri = new URI(this.filename);
        if (uri.getScheme() == null) {
            throw new URISyntaxException(this.filename, "filename must have a scheme");
        }
        if (uri.getScheme().equals(FILESYSTEM_SCHEME)) {
            return this.loadFilesystemScheme(uri);
        }
        if (uri.getScheme().equals(CLASSPATH_SCHEME)) {
            return this.loadClasspathScheme(uri);
        }
        if (uri.getScheme().equals(CONTEXT_SCHEME)) {
            return this.loadContextScheme(uri);
        }
        throw new URISyntaxException(this.filename, "scheme not supported");
    }

    private InputStream loadFilesystemScheme(URI uri) throws FileNotFoundException {
        String filepath = uri.getSchemeSpecificPart();
        return new FileInputStream(filepath);
    }

    private InputStream loadClasspathScheme(URI uri) throws FileNotFoundException {
        String filepath = uri.getSchemeSpecificPart();
        InputStream stream = WebAppFileLoader.class.getResourceAsStream(filepath);
        if (stream == null) {
            throw new FileNotFoundException();
        }
        return stream;
    }

    private InputStream loadContextScheme(URI uri) throws FileNotFoundException {
        String filepath = uri.getSchemeSpecificPart();
        if (this.context == null) {
            throw new RuntimeException("to load from the context, a context must be provided");
        }
        String realPath = this.context.getRealPath("/");
        String fileSep = System.getProperty("file.separator");
        if (realPath == null) {
            throw new RuntimeException("couldn't get the real path from context");
        }
        if (!realPath.endsWith(fileSep)) {
            realPath = realPath + fileSep;
        }
        if (filepath.startsWith(fileSep)) {
            filepath = filepath.substring(1);
        }
        return new FileInputStream(realPath + filepath);
    }
}

