/*
 * Decompiled with CFR 0.152.
 */
package com.pranavpandey.android.dynamic.util.concurrent;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.pranavpandey.android.dynamic.util.concurrent.DynamicResult;
import com.pranavpandey.android.dynamic.util.concurrent.DynamicRunnable;
import java.lang.ref.WeakReference;

public class DynamicHandler<P, R>
extends Handler {
    public static final int MESSAGE_POST_RESULT = 1;
    public static final int MESSAGE_POST_PROGRESS = 2;
    public static final int MESSAGE_NULL_IF_NOT = 3;
    private final WeakReference<DynamicRunnable<?, P, R>> mRunnable;

    public DynamicHandler(@NonNull Looper looper, @NonNull DynamicRunnable<?, P, R> runnable) {
        super(looper);
        this.mRunnable = new WeakReference(runnable);
    }

    public void handleMessage(@NonNull Message msg) {
        super.handleMessage(msg);
        if (this.getRunnable() == null) {
            return;
        }
        switch (msg.what) {
            case 1: {
                this.getRunnable().finish((DynamicResult)msg.obj);
                break;
            }
            case 2: {
                this.getRunnable().onProgressUpdate((DynamicResult)msg.obj);
            }
        }
    }

    @Nullable
    public DynamicRunnable<?, P, R> getRunnable() {
        if (this.mRunnable == null) {
            return null;
        }
        return (DynamicRunnable)this.mRunnable.get();
    }
}

