/*
 * Decompiled with CFR 0.152.
 */
package com.pranavpandey.android.dynamic.util;

import android.annotation.TargetApi;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Environment;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.pranavpandey.android.dynamic.util.DynamicSdkUtils;

public class DynamicIntentUtils {
    @NonNull
    public static Intent getIntent(@NonNull Context context, @Nullable Class<?> clazz, int flags) {
        Intent intent;
        if (clazz != null) {
            intent = new Intent(context, clazz);
            intent.setComponent(new ComponentName(context, clazz));
        } else {
            intent = new Intent();
        }
        intent.addFlags(flags);
        return intent;
    }

    @NonNull
    public static Intent getIntent(@NonNull Context context, @Nullable Class<?> clazz) {
        return DynamicIntentUtils.getIntent(context, clazz, 0);
    }

    @NonNull
    public static Intent getActivityIntent(@NonNull Context context, @Nullable Class<?> clazz) {
        return DynamicIntentUtils.getIntent(context, clazz, 0x14000000);
    }

    @NonNull
    public static Intent getActivityIntentForResult(@NonNull Context context, @Nullable Class<?> clazz) {
        return DynamicIntentUtils.getIntent(context, clazz, 0x4000000);
    }

    @Nullable
    public static Uri getStreamOrData(@Nullable Intent intent, @NonNull String action) {
        if (intent == null) {
            return null;
        }
        if (intent.getAction() != null && action.equals(intent.getAction()) && intent.getParcelableExtra("android.intent.extra.STREAM") != null) {
            return (Uri)intent.getParcelableExtra("android.intent.extra.STREAM");
        }
        return intent.getData();
    }

    public static boolean isActivityResolved(@Nullable Context context, @Nullable Intent intent) {
        if (context == null || intent == null) {
            return false;
        }
        return context.getPackageManager().resolveActivity(intent, 65536) != null;
    }

    @TargetApi(value=19)
    public static boolean isFilePicker(@Nullable Context context, boolean downloads) {
        Intent intent;
        if (context == null) {
            return false;
        }
        if (DynamicSdkUtils.is19()) {
            intent = new Intent("android.intent.action.OPEN_DOCUMENT");
            intent.setType("*/*");
        } else {
            intent = new Intent("android.intent.action.GET_CONTENT");
            if (downloads) {
                return Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_DOWNLOADS) != null;
            }
        }
        intent.addCategory("android.intent.category.OPENABLE");
        return DynamicIntentUtils.isActivityResolved(context, intent);
    }

    @TargetApi(value=19)
    public static boolean isFilePicker(@Nullable Context context) {
        return DynamicIntentUtils.isFilePicker(context, false);
    }

    @TargetApi(value=31)
    public static int addMutabilityFlag(int flags, boolean mutable) {
        if (DynamicSdkUtils.is23() && !mutable) {
            return flags | 0x4000000;
        }
        if (DynamicSdkUtils.is31() && mutable) {
            return flags | 0x2000000;
        }
        return flags;
    }

    public static int addMutableFlag(int flags) {
        return DynamicIntentUtils.addMutabilityFlag(flags, true);
    }

    public static int addImmutableFlag(int flags) {
        return DynamicIntentUtils.addMutabilityFlag(flags, false);
    }

    @TargetApi(value=30)
    public static boolean viewIntent(@Nullable Context context, @Nullable Intent intent) {
        if (context == null || intent == null) {
            return false;
        }
        Intent intentTemp = new Intent(intent);
        intentTemp.addCategory("android.intent.category.BROWSABLE");
        intentTemp.addFlags(0x10000000);
        try {
            if (DynamicSdkUtils.is30()) {
                intentTemp.addFlags(1024);
            }
            context.startActivity(intentTemp);
            return true;
        }
        catch (Exception ignored) {
            intentTemp = new Intent(intent);
            intentTemp.addCategory("android.intent.category.BROWSABLE");
            intentTemp.addFlags(0x10000000);
            if (DynamicIntentUtils.isActivityResolved(context, intentTemp)) {
                context.startActivity(intentTemp);
                return true;
            }
            return false;
        }
    }
}

