/*
 * Decompiled with CFR 0.152.
 */
package com.pranavpandey.android.dynamic.util;

import android.text.InputFilter;
import android.view.View;
import android.widget.TextView;
import androidx.annotation.Nullable;
import java.util.ArrayList;
import java.util.Arrays;

public class DynamicInputUtils {
    public static void setFilter(@Nullable View view, @Nullable InputFilter filter) {
        if (filter == null) {
            return;
        }
        if (view instanceof TextView) {
            InputFilter[] filters = ((TextView)view).getFilters();
            if (filters == null) {
                filters = new InputFilter[1];
            }
            ArrayList<InputFilter> filtersList = new ArrayList<InputFilter>(Arrays.asList(filters));
            filtersList.add(filter);
            ((TextView)view).setFilters(filtersList.toArray(new InputFilter[0]));
        }
    }

    public static void removeFilter(@Nullable View view, @Nullable InputFilter filter) {
        if (filter == null) {
            return;
        }
        if (view instanceof TextView) {
            InputFilter[] filters = ((TextView)view).getFilters();
            if (filters == null) {
                filters = new InputFilter[1];
            }
            ArrayList<InputFilter> filtersList = new ArrayList<InputFilter>(Arrays.asList(filters));
            for (InputFilter inputFilter : filtersList) {
                if (!inputFilter.getClass().isInstance(filter)) continue;
                filtersList.remove(inputFilter);
            }
            ((TextView)view).setFilters(filtersList.toArray(new InputFilter[0]));
        }
    }

    public static void setMaxLength(@Nullable View view, int length) {
        DynamicInputUtils.setFilter(view, (InputFilter)new InputFilter.LengthFilter(length));
    }

    public static void setAllCaps(@Nullable View view, boolean allCaps) {
        if (allCaps) {
            DynamicInputUtils.setFilter(view, (InputFilter)new InputFilter.AllCaps());
        } else {
            DynamicInputUtils.removeFilter(view, (InputFilter)new InputFilter.AllCaps());
        }
    }
}

