/*
 * Decompiled with CFR 0.152.
 */
package com.polidea.rxandroidble2.internal.util;

import android.annotation.TargetApi;
import bleshadow.javax.inject.Inject;
import bleshadow.javax.inject.Named;
import com.polidea.rxandroidble2.internal.util.CheckerLocationProvider;
import com.polidea.rxandroidble2.internal.util.CheckerScanPermission;
import com.polidea.rxandroidble2.internal.util.LocationServicesStatus;

@TargetApi(value=31)
public class LocationServicesStatusApi31
implements LocationServicesStatus {
    private final CheckerLocationProvider checkerLocationProvider;
    private final CheckerScanPermission checkerScanPermission;
    private final boolean isAndroidWear;
    private final boolean isNearbyPermissionNeverForLoc;

    @Inject
    LocationServicesStatusApi31(CheckerLocationProvider checkerLocationProvider, CheckerScanPermission checkerScanPermission, @Named(value="android-wear") boolean isAndroidWear, @Named(value="nearby-permission-never-for-location") boolean isNearbyPermissionNeverForLoc) {
        this.checkerLocationProvider = checkerLocationProvider;
        this.checkerScanPermission = checkerScanPermission;
        this.isAndroidWear = isAndroidWear;
        this.isNearbyPermissionNeverForLoc = isNearbyPermissionNeverForLoc;
    }

    @Override
    public boolean isLocationPermissionOk() {
        return this.checkerScanPermission.isScanRuntimePermissionGranted();
    }

    @Override
    public boolean isLocationProviderOk() {
        return !this.isLocationProviderEnabledRequired() || this.checkerLocationProvider.isLocationProviderEnabled();
    }

    private boolean isLocationProviderEnabledRequired() {
        if (this.isAndroidWear) {
            return false;
        }
        return !this.isNearbyPermissionNeverForLoc;
    }
}

