/*
 * Decompiled with CFR 0.152.
 */
package com.polidea.rxandroidble2.internal.util;

import bleshadow.javax.inject.Inject;
import bleshadow.javax.inject.Named;
import com.polidea.rxandroidble2.ClientScope;
import com.polidea.rxandroidble2.internal.util.CheckerPermission;

@ClientScope
public class CheckerConnectPermission {
    private final CheckerPermission checkerPermission;
    private final String[][] connectPermissions;

    @Inject
    CheckerConnectPermission(CheckerPermission checkerPermission, @Named(value="connect-permissions") String[][] connectPermissions) {
        this.checkerPermission = checkerPermission;
        this.connectPermissions = connectPermissions;
    }

    public boolean isConnectRuntimePermissionGranted() {
        boolean allNeededPermissionsGranted = true;
        for (String[] neededPermissions : this.connectPermissions) {
            allNeededPermissionsGranted &= this.checkerPermission.isAnyPermissionGranted(neededPermissions);
        }
        return allNeededPermissionsGranted;
    }

    public String[] getRecommendedConnectRuntimePermissions() {
        int allPermissionsCount = 0;
        for (String[] permissionsArray : this.connectPermissions) {
            allPermissionsCount += permissionsArray.length;
        }
        String[] resultPermissions = new String[allPermissionsCount];
        int i = 0;
        String[][] stringArray = this.connectPermissions;
        int n = stringArray.length;
        for (int j = 0; j < n; ++j) {
            String[] permissionsArray;
            for (String permission2 : permissionsArray = stringArray[j]) {
                resultPermissions[i++] = permission2;
            }
        }
        return resultPermissions;
    }
}

