/*
 * Decompiled with CFR 0.152.
 */
package com.polidea.rxandroidble2.internal.scan;

import android.os.Build;
import android.os.ParcelUuid;
import android.util.SparseArray;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import com.polidea.rxandroidble2.internal.util.ScanRecordParser;
import com.polidea.rxandroidble2.scan.ScanRecord;
import java.util.List;
import java.util.Map;

@RequiresApi(value=21)
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class ScanRecordImplNativeWrapper
implements ScanRecord {
    private final android.bluetooth.le.ScanRecord nativeScanRecord;
    private final ScanRecordParser scanRecordParser;

    public ScanRecordImplNativeWrapper(android.bluetooth.le.ScanRecord nativeScanRecord, ScanRecordParser scanRecordParser) {
        this.nativeScanRecord = nativeScanRecord;
        this.scanRecordParser = scanRecordParser;
    }

    @Override
    public int getAdvertiseFlags() {
        return this.nativeScanRecord.getAdvertiseFlags();
    }

    @Override
    public List<ParcelUuid> getServiceUuids() {
        return this.nativeScanRecord.getServiceUuids();
    }

    @Override
    public List<ParcelUuid> getServiceSolicitationUuids() {
        if (Build.VERSION.SDK_INT >= 29) {
            return this.nativeScanRecord.getServiceSolicitationUuids();
        }
        return this.scanRecordParser.parseFromBytes(this.nativeScanRecord.getBytes()).getServiceSolicitationUuids();
    }

    @Override
    public SparseArray<byte[]> getManufacturerSpecificData() {
        return this.nativeScanRecord.getManufacturerSpecificData();
    }

    @Override
    @Nullable
    public byte[] getManufacturerSpecificData(int manufacturerId) {
        return this.nativeScanRecord.getManufacturerSpecificData(manufacturerId);
    }

    @Override
    public Map<ParcelUuid, byte[]> getServiceData() {
        return this.nativeScanRecord.getServiceData();
    }

    @Override
    @Nullable
    public byte[] getServiceData(ParcelUuid serviceDataUuid) {
        return this.nativeScanRecord.getServiceData(serviceDataUuid);
    }

    @Override
    public int getTxPowerLevel() {
        return this.nativeScanRecord.getTxPowerLevel();
    }

    @Override
    @Nullable
    public String getDeviceName() {
        return this.nativeScanRecord.getDeviceName();
    }

    @Override
    public byte[] getBytes() {
        return this.nativeScanRecord.getBytes();
    }
}

