/*
 * Decompiled with CFR 0.152.
 */
package com.polidea.rxandroidble2.internal.scan;

import android.bluetooth.BluetoothDevice;
import android.bluetooth.le.ScanResult;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import bleshadow.javax.inject.Inject;
import com.polidea.rxandroidble2.ClientScope;
import com.polidea.rxandroidble2.internal.RxBleLog;
import com.polidea.rxandroidble2.internal.scan.IsConnectableChecker;
import com.polidea.rxandroidble2.internal.scan.RxBleInternalScanResult;
import com.polidea.rxandroidble2.internal.scan.ScanRecordImplNativeWrapper;
import com.polidea.rxandroidble2.internal.util.ScanRecordParser;
import com.polidea.rxandroidble2.scan.IsConnectable;
import com.polidea.rxandroidble2.scan.ScanCallbackType;
import com.polidea.rxandroidble2.scan.ScanRecord;

@ClientScope
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class InternalScanResultCreator {
    private final ScanRecordParser scanRecordParser;
    private final IsConnectableChecker isConnectableChecker;

    @Inject
    public InternalScanResultCreator(ScanRecordParser scanRecordParser, IsConnectableChecker isConnectableChecker) {
        this.scanRecordParser = scanRecordParser;
        this.isConnectableChecker = isConnectableChecker;
    }

    public RxBleInternalScanResult create(BluetoothDevice bluetoothDevice, int rssi, byte[] scanRecord) {
        ScanRecord scanRecordObj = this.scanRecordParser.parseFromBytes(scanRecord);
        return new RxBleInternalScanResult(bluetoothDevice, rssi, System.nanoTime(), scanRecordObj, ScanCallbackType.CALLBACK_TYPE_UNSPECIFIED, IsConnectable.LEGACY_UNKNOWN);
    }

    @RequiresApi(value=21)
    public RxBleInternalScanResult create(ScanResult result) {
        ScanRecordImplNativeWrapper scanRecord = new ScanRecordImplNativeWrapper(result.getScanRecord(), this.scanRecordParser);
        return new RxBleInternalScanResult(result.getDevice(), result.getRssi(), result.getTimestampNanos(), scanRecord, ScanCallbackType.CALLBACK_TYPE_BATCH, this.isConnectableChecker.check(result));
    }

    @RequiresApi(value=21)
    public RxBleInternalScanResult create(int callbackType, ScanResult result) {
        ScanRecordImplNativeWrapper scanRecord = new ScanRecordImplNativeWrapper(result.getScanRecord(), this.scanRecordParser);
        return new RxBleInternalScanResult(result.getDevice(), result.getRssi(), result.getTimestampNanos(), scanRecord, InternalScanResultCreator.toScanCallbackType(callbackType), this.isConnectableChecker.check(result));
    }

    @RequiresApi(value=21)
    private static ScanCallbackType toScanCallbackType(int callbackType) {
        switch (callbackType) {
            case 1: {
                return ScanCallbackType.CALLBACK_TYPE_ALL_MATCHES;
            }
            case 2: {
                return ScanCallbackType.CALLBACK_TYPE_FIRST_MATCH;
            }
            case 4: {
                return ScanCallbackType.CALLBACK_TYPE_MATCH_LOST;
            }
        }
        RxBleLog.w("Unknown callback type %d -> check android.bluetooth.le.ScanSettings", callbackType);
        return ScanCallbackType.CALLBACK_TYPE_UNKNOWN;
    }
}

