/*
 * Decompiled with CFR 0.152.
 */
package com.polidea.rxandroidble2.internal.scan;

import androidx.annotation.Nullable;
import com.polidea.rxandroidble2.internal.scan.RxBleInternalScanResult;
import com.polidea.rxandroidble2.internal.scan.ScanFilterInterface;
import java.util.Arrays;

public class EmulatedScanFilterMatcher {
    @Nullable
    private final ScanFilterInterface[] scanFilters;
    private final boolean isEmpty;

    public EmulatedScanFilterMatcher(ScanFilterInterface ... scanFilters) {
        this.scanFilters = scanFilters;
        boolean tempIsEmpty = true;
        if (scanFilters != null && scanFilters.length != 0) {
            for (ScanFilterInterface scanFilter : scanFilters) {
                if (scanFilter.isAllFieldsEmpty()) continue;
                tempIsEmpty = false;
                break;
            }
        }
        this.isEmpty = tempIsEmpty;
    }

    public boolean matches(RxBleInternalScanResult internalScanResult) {
        if (this.scanFilters == null || this.scanFilters.length == 0) {
            return true;
        }
        for (ScanFilterInterface scanFilter : this.scanFilters) {
            if (!scanFilter.matches(internalScanResult)) continue;
            return true;
        }
        return false;
    }

    public boolean isEmpty() {
        return this.isEmpty;
    }

    public String toString() {
        return "emulatedFilters=" + Arrays.toString(this.scanFilters);
    }
}

