/*
 * Decompiled with CFR 0.152.
 */
package com.polidea.rxandroidble2.internal.operations;

import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothManager;
import android.os.DeadObjectException;
import androidx.annotation.RestrictTo;
import bleshadow.javax.inject.Inject;
import bleshadow.javax.inject.Named;
import com.polidea.rxandroidble2.RxBleConnection;
import com.polidea.rxandroidble2.exceptions.BleDisconnectedException;
import com.polidea.rxandroidble2.exceptions.BleException;
import com.polidea.rxandroidble2.internal.QueueOperation;
import com.polidea.rxandroidble2.internal.RxBleLog;
import com.polidea.rxandroidble2.internal.connection.BluetoothGattProvider;
import com.polidea.rxandroidble2.internal.connection.ConnectionStateChangeListener;
import com.polidea.rxandroidble2.internal.connection.RxBleGattCallback;
import com.polidea.rxandroidble2.internal.logger.LoggerUtil;
import com.polidea.rxandroidble2.internal.operations.TimeoutConfiguration;
import com.polidea.rxandroidble2.internal.serialization.QueueReleaseInterface;
import io.reactivex.Emitter;
import io.reactivex.ObservableEmitter;
import io.reactivex.Scheduler;
import io.reactivex.Single;
import io.reactivex.SingleObserver;
import io.reactivex.SingleSource;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Function;
import io.reactivex.functions.Predicate;

public class DisconnectOperation
extends QueueOperation<Void> {
    private final RxBleGattCallback rxBleGattCallback;
    private final BluetoothGattProvider bluetoothGattProvider;
    private final String macAddress;
    private final BluetoothManager bluetoothManager;
    private final Scheduler bluetoothInteractionScheduler;
    private final TimeoutConfiguration timeoutConfiguration;
    private final ConnectionStateChangeListener connectionStateChangeListener;

    @Inject
    DisconnectOperation(RxBleGattCallback rxBleGattCallback, BluetoothGattProvider bluetoothGattProvider, @Named(value="mac-address") String macAddress, BluetoothManager bluetoothManager, @Named(value="bluetooth_interaction") Scheduler bluetoothInteractionScheduler, @Named(value="disconnect-timeout") TimeoutConfiguration timeoutConfiguration, ConnectionStateChangeListener connectionStateChangeListener) {
        this.rxBleGattCallback = rxBleGattCallback;
        this.bluetoothGattProvider = bluetoothGattProvider;
        this.macAddress = macAddress;
        this.bluetoothManager = bluetoothManager;
        this.bluetoothInteractionScheduler = bluetoothInteractionScheduler;
        this.timeoutConfiguration = timeoutConfiguration;
        this.connectionStateChangeListener = connectionStateChangeListener;
    }

    @Override
    protected void protectedRun(final ObservableEmitter<Void> emitter, final QueueReleaseInterface queueReleaseInterface) {
        this.connectionStateChangeListener.onConnectionStateChange(RxBleConnection.RxBleConnectionState.DISCONNECTING);
        BluetoothGatt bluetoothGatt = this.bluetoothGattProvider.getBluetoothGatt();
        if (bluetoothGatt == null) {
            RxBleLog.w("Disconnect operation has been executed but GATT instance was null - considering disconnected.", new Object[0]);
            this.considerGattDisconnected((Emitter<Void>)emitter, queueReleaseInterface);
        } else {
            this.disconnectIfRequired(bluetoothGatt).observeOn(this.bluetoothInteractionScheduler).subscribe((SingleObserver)new SingleObserver<BluetoothGatt>(){

                public void onSubscribe(Disposable d) {
                }

                public void onSuccess(BluetoothGatt bluetoothGatt) {
                    bluetoothGatt.close();
                    DisconnectOperation.this.considerGattDisconnected((Emitter<Void>)emitter, queueReleaseInterface);
                }

                public void onError(Throwable throwable) {
                    RxBleLog.w(throwable, "Disconnect operation has been executed but finished with an error - considering disconnected.", new Object[0]);
                    DisconnectOperation.this.considerGattDisconnected((Emitter<Void>)emitter, queueReleaseInterface);
                }
            });
        }
    }

    private Single<BluetoothGatt> disconnectIfRequired(BluetoothGatt bluetoothGatt) {
        return this.isDisconnected(bluetoothGatt) ? Single.just((Object)bluetoothGatt) : this.disconnect(bluetoothGatt);
    }

    @RestrictTo(value={RestrictTo.Scope.SUBCLASSES})
    void considerGattDisconnected(Emitter<Void> emitter, QueueReleaseInterface queueReleaseInterface) {
        this.connectionStateChangeListener.onConnectionStateChange(RxBleConnection.RxBleConnectionState.DISCONNECTED);
        queueReleaseInterface.release();
        emitter.onComplete();
    }

    private boolean isDisconnected(BluetoothGatt bluetoothGatt) {
        return this.bluetoothManager.getConnectionState(bluetoothGatt.getDevice(), 7) == 0;
    }

    private Single<BluetoothGatt> disconnect(BluetoothGatt bluetoothGatt) {
        return new DisconnectGattObservable(bluetoothGatt, this.rxBleGattCallback, this.bluetoothInteractionScheduler).timeout(this.timeoutConfiguration.timeout, this.timeoutConfiguration.timeoutTimeUnit, this.timeoutConfiguration.timeoutScheduler, (SingleSource)Single.just((Object)bluetoothGatt));
    }

    @Override
    protected BleException provideException(DeadObjectException deadObjectException) {
        return new BleDisconnectedException(deadObjectException, this.macAddress, -1);
    }

    public String toString() {
        return "DisconnectOperation{" + LoggerUtil.commonMacMessage(this.macAddress) + '}';
    }

    private static class DisconnectGattObservable
    extends Single<BluetoothGatt> {
        final BluetoothGatt bluetoothGatt;
        private final RxBleGattCallback rxBleGattCallback;
        private final Scheduler disconnectScheduler;

        DisconnectGattObservable(BluetoothGatt bluetoothGatt, RxBleGattCallback rxBleGattCallback, Scheduler disconnectScheduler) {
            this.bluetoothGatt = bluetoothGatt;
            this.rxBleGattCallback = rxBleGattCallback;
            this.disconnectScheduler = disconnectScheduler;
        }

        protected void subscribeActual(SingleObserver<? super BluetoothGatt> observer) {
            this.rxBleGattCallback.getOnConnectionStateChange().filter((Predicate)new Predicate<RxBleConnection.RxBleConnectionState>(){

                public boolean test(RxBleConnection.RxBleConnectionState rxBleConnectionState) {
                    return rxBleConnectionState == RxBleConnection.RxBleConnectionState.DISCONNECTED;
                }
            }).firstOrError().map((Function)new Function<RxBleConnection.RxBleConnectionState, BluetoothGatt>(){

                public BluetoothGatt apply(RxBleConnection.RxBleConnectionState rxBleConnectionState) {
                    return bluetoothGatt;
                }
            }).subscribe(observer);
            this.disconnectScheduler.createWorker().schedule(new Runnable(){

                @Override
                public void run() {
                    bluetoothGatt.disconnect();
                }
            });
        }
    }
}

