/*
 * Decompiled with CFR 0.152.
 */
package com.polidea.rxandroidble2.internal.logger;

import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattDescriptor;
import android.bluetooth.BluetoothGattService;
import bleshadow.javax.inject.Inject;
import com.polidea.rxandroidble2.RxBleDeviceServices;
import com.polidea.rxandroidble2.internal.RxBleLog;
import com.polidea.rxandroidble2.internal.logger.LoggerUtil;
import com.polidea.rxandroidble2.internal.util.CharacteristicPropertiesParser;
import com.polidea.rxandroidble2.utils.StandardUUIDsParser;

public class LoggerUtilBluetoothServices {
    private final CharacteristicPropertiesParser characteristicPropertiesParser;

    @Inject
    LoggerUtilBluetoothServices(CharacteristicPropertiesParser characteristicPropertiesParser) {
        this.characteristicPropertiesParser = characteristicPropertiesParser;
    }

    public void log(RxBleDeviceServices rxBleDeviceServices, BluetoothDevice device) {
        if (RxBleLog.isAtLeast(2)) {
            RxBleLog.v("Preparing services description", new Object[0]);
            RxBleLog.v(this.prepareServicesDescription(rxBleDeviceServices, device), new Object[0]);
        }
    }

    private String prepareServicesDescription(RxBleDeviceServices rxBleDeviceServices, BluetoothDevice device) {
        StringBuilder descriptionBuilder = new StringBuilder();
        LoggerUtilBluetoothServices.appendDeviceHeader(device, descriptionBuilder);
        for (BluetoothGattService bluetoothGattService : rxBleDeviceServices.getBluetoothGattServices()) {
            descriptionBuilder.append('\n');
            this.appendServiceDescription(descriptionBuilder, bluetoothGattService);
        }
        descriptionBuilder.append("\n--------------- ====== Finished peripheral content ====== ---------------");
        return descriptionBuilder.toString();
    }

    private void appendServiceDescription(StringBuilder descriptionBuilder, BluetoothGattService bluetoothGattService) {
        LoggerUtilBluetoothServices.appendServiceHeader(descriptionBuilder, bluetoothGattService);
        descriptionBuilder.append("-> Characteristics:");
        for (BluetoothGattCharacteristic characteristic : bluetoothGattService.getCharacteristics()) {
            LoggerUtilBluetoothServices.appendCharacteristicNameHeader(descriptionBuilder, characteristic);
            this.appendCharacteristicProperties(descriptionBuilder, characteristic);
            LoggerUtilBluetoothServices.appendDescriptors(descriptionBuilder, characteristic);
        }
    }

    private static void appendDescriptors(StringBuilder descriptionBuilder, BluetoothGattCharacteristic characteristic) {
        if (!characteristic.getDescriptors().isEmpty()) {
            LoggerUtilBluetoothServices.appendDescriptorsHeader(descriptionBuilder);
            for (BluetoothGattDescriptor descriptor : characteristic.getDescriptors()) {
                LoggerUtilBluetoothServices.appendDescriptorNameHeader(descriptionBuilder, descriptor);
            }
        }
    }

    private static void appendDescriptorsHeader(StringBuilder descriptionBuilder) {
        descriptionBuilder.append('\n').append('\t').append("  ").append("-> Descriptors: ");
    }

    private static void appendCharacteristicNameHeader(StringBuilder descriptionBuilder, BluetoothGattCharacteristic characteristic) {
        descriptionBuilder.append('\n').append('\t').append("* ").append(LoggerUtilBluetoothServices.createCharacteristicName(characteristic)).append(" (").append(LoggerUtil.getUuidToLog(characteristic.getUuid())).append(")");
    }

    private static void appendDescriptorNameHeader(StringBuilder descriptionBuilder, BluetoothGattDescriptor descriptor) {
        descriptionBuilder.append('\n').append('\t').append('\t').append("* ").append(LoggerUtilBluetoothServices.createDescriptorName(descriptor)).append(" (").append(LoggerUtil.getUuidToLog(descriptor.getUuid())).append(")");
    }

    private static String createDescriptorName(BluetoothGattDescriptor descriptor) {
        String descriptorName = StandardUUIDsParser.getDescriptorName(descriptor.getUuid());
        return descriptorName == null ? "Unknown descriptor" : descriptorName;
    }

    private void appendCharacteristicProperties(StringBuilder descriptionBuilder, BluetoothGattCharacteristic characteristic) {
        descriptionBuilder.append('\n').append('\t').append("  ").append("Properties: ").append(this.characteristicPropertiesParser.propertiesIntToString(characteristic.getProperties()));
    }

    private static String createCharacteristicName(BluetoothGattCharacteristic characteristic) {
        String characteristicName = StandardUUIDsParser.getCharacteristicName(characteristic.getUuid());
        return characteristicName == null ? "Unknown characteristic" : characteristicName;
    }

    private static void appendDeviceHeader(BluetoothDevice device, StringBuilder descriptionBuilder) {
        descriptionBuilder.append("--------------- ====== Printing peripheral content ====== ---------------\n").append(LoggerUtil.commonMacMessage(device.getAddress())).append('\n').append("PERIPHERAL NAME: ").append(device.getName()).append('\n').append("-------------------------------------------------------------------------");
    }

    private static void appendServiceHeader(StringBuilder descriptionBuilder, BluetoothGattService bluetoothGattService) {
        descriptionBuilder.append("\n").append(LoggerUtilBluetoothServices.createServiceType(bluetoothGattService)).append(" - ").append(LoggerUtilBluetoothServices.createServiceName(bluetoothGattService)).append(" (").append(LoggerUtil.getUuidToLog(bluetoothGattService.getUuid())).append(")\n").append("Instance ID: ").append(bluetoothGattService.getInstanceId()).append('\n');
    }

    private static String createServiceName(BluetoothGattService bluetoothGattService) {
        String serviceName = StandardUUIDsParser.getServiceName(bluetoothGattService.getUuid());
        return serviceName == null ? "Unknown service" : serviceName;
    }

    private static String createServiceType(BluetoothGattService bluetoothGattService) {
        if (bluetoothGattService.getType() == 0) {
            return "Primary Service";
        }
        return "Secondary Service";
    }
}

