/*
 * Decompiled with CFR 0.152.
 */
package com.polidea.rxandroidble2.internal.connection;

import bleshadow.javax.inject.Inject;
import bleshadow.javax.inject.Named;
import com.jakewharton.rxrelay2.BehaviorRelay;
import com.polidea.rxandroidble2.RxBleAdapterStateObservable;
import com.polidea.rxandroidble2.exceptions.BleDisconnectedException;
import com.polidea.rxandroidble2.exceptions.BleException;
import com.polidea.rxandroidble2.exceptions.BleGattException;
import com.polidea.rxandroidble2.internal.RxBleLog;
import com.polidea.rxandroidble2.internal.connection.ConnectionScope;
import com.polidea.rxandroidble2.internal.connection.DisconnectionRouterInput;
import com.polidea.rxandroidble2.internal.connection.DisconnectionRouterOutput;
import com.polidea.rxandroidble2.internal.util.RxBleAdapterWrapper;
import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Action;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.Function;
import io.reactivex.functions.Predicate;

@ConnectionScope
class DisconnectionRouter
implements DisconnectionRouterInput,
DisconnectionRouterOutput {
    private final BehaviorRelay<BleException> bleExceptionBehaviorRelay = BehaviorRelay.create();
    private final Observable<BleException> firstDisconnectionValueObs;
    private final Observable<Object> firstDisconnectionExceptionObs;

    @Inject
    DisconnectionRouter(final @Named(value="mac-address") String macAddress, RxBleAdapterWrapper adapterWrapper, Observable<RxBleAdapterStateObservable.BleAdapterState> adapterStateObservable) {
        final Disposable adapterMonitoringDisposable = DisconnectionRouter.awaitAdapterNotUsable(adapterWrapper, adapterStateObservable).map((Function)new Function<Boolean, BleException>(){

            public BleException apply(Boolean isAdapterUsable) {
                return BleDisconnectedException.adapterDisabled(macAddress);
            }
        }).doOnNext((Consumer)new Consumer<BleException>(){

            public void accept(BleException exception) {
                RxBleLog.v("An exception received, indicating that the adapter has became unusable.", new Object[0]);
            }
        }).subscribe(this.bleExceptionBehaviorRelay, (Consumer)new Consumer<Throwable>(){

            public void accept(Throwable throwable) {
                RxBleLog.e(throwable, "Failed to monitor adapter state.", new Object[0]);
            }
        });
        this.firstDisconnectionValueObs = this.bleExceptionBehaviorRelay.firstElement().toObservable().doOnTerminate(new Action(){

            public void run() {
                adapterMonitoringDisposable.dispose();
            }
        }).replay().autoConnect(0);
        this.firstDisconnectionExceptionObs = this.firstDisconnectionValueObs.flatMap(new Function<BleException, ObservableSource<?>>(){

            public ObservableSource<?> apply(BleException e) {
                return Observable.error((Throwable)e);
            }
        });
    }

    private static Observable<Boolean> awaitAdapterNotUsable(RxBleAdapterWrapper adapterWrapper, Observable<RxBleAdapterStateObservable.BleAdapterState> stateChanges) {
        return stateChanges.map((Function)new Function<RxBleAdapterStateObservable.BleAdapterState, Boolean>(){

            public Boolean apply(RxBleAdapterStateObservable.BleAdapterState bleAdapterState) {
                return bleAdapterState.isUsable();
            }
        }).startWith((Object)adapterWrapper.isBluetoothEnabled()).filter((Predicate)new Predicate<Boolean>(){

            public boolean test(Boolean isAdapterUsable) {
                return isAdapterUsable == false;
            }
        });
    }

    @Override
    public void onDisconnectedException(BleDisconnectedException disconnectedException) {
        this.bleExceptionBehaviorRelay.accept((Object)disconnectedException);
    }

    @Override
    public void onGattConnectionStateException(BleGattException disconnectedGattException) {
        this.bleExceptionBehaviorRelay.accept((Object)disconnectedGattException);
    }

    @Override
    public Observable<BleException> asValueOnlyObservable() {
        return this.firstDisconnectionValueObs;
    }

    @Override
    public <T> Observable<T> asErrorOnlyObservable() {
        return this.firstDisconnectionExceptionObs;
    }
}

