/*
 * Decompiled with CFR 0.152.
 */
package com.polidea.rxandroidble2.internal;

import android.os.DeadObjectException;
import androidx.annotation.NonNull;
import com.polidea.rxandroidble2.exceptions.BleException;
import com.polidea.rxandroidble2.internal.Priority;
import com.polidea.rxandroidble2.internal.RxBleLog;
import com.polidea.rxandroidble2.internal.operations.Operation;
import com.polidea.rxandroidble2.internal.serialization.QueueReleaseInterface;
import io.reactivex.Observable;
import io.reactivex.ObservableEmitter;
import io.reactivex.ObservableOnSubscribe;

public abstract class QueueOperation<T>
implements Operation<T> {
    @Override
    public final Observable<T> run(final QueueReleaseInterface queueReleaseInterface) {
        return Observable.create((ObservableOnSubscribe)new ObservableOnSubscribe<T>(){

            public void subscribe(ObservableEmitter<T> emitter) {
                try {
                    QueueOperation.this.protectedRun(emitter, queueReleaseInterface);
                }
                catch (DeadObjectException deadObjectException) {
                    emitter.tryOnError((Throwable)QueueOperation.this.provideException(deadObjectException));
                    RxBleLog.e(deadObjectException, "QueueOperation terminated with a DeadObjectException", new Object[0]);
                }
                catch (Throwable throwable) {
                    emitter.tryOnError(throwable);
                    RxBleLog.e(throwable, "QueueOperation terminated with an unexpected exception", new Object[0]);
                }
            }
        });
    }

    protected abstract void protectedRun(ObservableEmitter<T> var1, QueueReleaseInterface var2) throws Throwable;

    protected abstract BleException provideException(DeadObjectException var1);

    @Override
    public Priority definedPriority() {
        return Priority.NORMAL;
    }

    @Override
    public int compareTo(@NonNull Operation another) {
        return another.definedPriority().priority - this.definedPriority().priority;
    }
}

