/*
 * Decompiled with CFR 0.152.
 */
package com.polidea.rxandroidble2;

import com.polidea.rxandroidble2.Timeout;
import java.util.concurrent.TimeUnit;

public class ConnectionSetup {
    public static final int DEFAULT_OPERATION_TIMEOUT = 30;
    public final boolean autoConnect;
    public final boolean suppressOperationCheck;
    public final Timeout operationTimeout;

    ConnectionSetup(boolean autoConnect, boolean suppressOperationCheck, Timeout operationTimeout) {
        this.autoConnect = autoConnect;
        this.suppressOperationCheck = suppressOperationCheck;
        this.operationTimeout = operationTimeout;
    }

    public static class Builder {
        private boolean autoConnect = false;
        private boolean suppressOperationCheck = false;
        private Timeout operationTimeout = new Timeout(30L, TimeUnit.SECONDS);

        public Builder setAutoConnect(boolean autoConnect) {
            this.autoConnect = autoConnect;
            return this;
        }

        public Builder setSuppressIllegalOperationCheck(boolean suppressOperationCheck) {
            this.suppressOperationCheck = suppressOperationCheck;
            return this;
        }

        public Builder setOperationTimeout(Timeout operationTimeout) {
            this.operationTimeout = operationTimeout;
            return this;
        }

        public ConnectionSetup build() {
            return new ConnectionSetup(this.autoConnect, this.suppressOperationCheck, this.operationTimeout);
        }
    }
}

