/*
 * Decompiled with CFR 0.152.
 */
package com.plivo.api.models.token;

import com.plivo.api.exceptions.PlivoRestException;
import com.plivo.api.models.base.VoiceCreator;
import com.plivo.api.models.token.TokenCreateResponse;
import com.plivo.api.models.token.TokenPermission;
import java.io.IOException;
import retrofit2.Call;

public class TokenCreator
extends VoiceCreator<TokenCreateResponse> {
    private final String iss;
    private String sub;
    private Integer nbf;
    private Integer exp;
    private String app;
    private TokenPermission per;

    public TokenCreator(String iss) {
        this.iss = iss;
        this.per = new TokenPermission();
    }

    public String sub() {
        return this.sub;
    }

    public TokenCreator sub(String sub) {
        this.sub = sub;
        return this;
    }

    public Integer nbf() {
        return this.nbf;
    }

    public TokenCreator nbf(Integer nbf) {
        this.nbf = nbf;
        return this;
    }

    public Integer exp() {
        return this.exp;
    }

    public TokenCreator exp(Integer exp) {
        this.exp = exp;
        return this;
    }

    public String app() {
        return this.app;
    }

    public TokenCreator app(String app) {
        this.app = app;
        return this;
    }

    public boolean incoming_allow() {
        return this.per.voice.incomingAllow;
    }

    public TokenCreator incoming_allow(boolean incoming_allow) {
        this.per.voice.incomingAllow = incoming_allow;
        return this;
    }

    public boolean outgoing_allow() {
        return this.per.voice.outgoingAllow;
    }

    public TokenCreator outgoing_allow(boolean outgoing_allow) {
        this.per.voice.outgoingAllow = outgoing_allow;
        return this;
    }

    public TokenPermission per() {
        return this.per;
    }

    public TokenCreateResponse createToken() throws PlivoRestException, IOException {
        this.validateParams();
        return (TokenCreateResponse)this.create();
    }

    private void validateParams() {
        if (this.sub == null && this.incoming_allow()) {
            throw new IllegalArgumentException("sub should be present if incoming is allowed");
        }
        if (this.nbf() != null && this.exp() != null && this.nbf > this.exp) {
            throw new IllegalArgumentException("exp should be greater than nbf");
        }
    }

    @Override
    protected Call<TokenCreateResponse> obtainCall() {
        return this.client().getVoiceApiService().tokenCreate(this.client().getAuthId(), this);
    }

    @Override
    protected Call<TokenCreateResponse> obtainFallback1Call() {
        return this.client().getVoiceFallback1Service().tokenCreate(this.client().getAuthId(), this);
    }

    @Override
    protected Call<TokenCreateResponse> obtainFallback2Call() {
        return this.client().getVoiceFallback2Service().tokenCreate(this.client().getAuthId(), this);
    }
}

