/*
 * Decompiled with CFR 0.152.
 */
package com.plivo.api.models.powerpack;

import com.plivo.api.models.base.Getter;
import com.plivo.api.models.base.ListResponse;
import com.plivo.api.models.number.PhoneNumber;
import com.plivo.api.models.powerpack.Numbers;
import retrofit2.Call;

public class BuyAddNumbers
extends Getter<Numbers> {
    private String number;
    private String uuid;
    private String country_Iso2;
    private String service;
    private Boolean rent;

    public BuyAddNumbers(String uuid) {
        super(uuid);
        if (uuid == null) {
            throw new IllegalArgumentException("numberpool uuid cannot be null");
        }
        this.uuid = uuid;
        this.rent = Boolean.TRUE;
    }

    public BuyAddNumbers country_Iso2(String country_Iso2) {
        this.country_Iso2 = country_Iso2;
        return this;
    }

    public BuyAddNumbers rent() {
        this.rent = Boolean.TRUE;
        return this;
    }

    public BuyAddNumbers number(String number) {
        this.number = number;
        return this;
    }

    public BuyAddNumbers service(String service) {
        this.service = service;
        return this;
    }

    @Override
    protected Call<Numbers> obtainCall() {
        if (this.number == null) {
            try {
                ListResponse numbers = PhoneNumber.lister(this.country_Iso2).list();
                if (numbers.getObjects().size() > 0) {
                    this.number = ((PhoneNumber)numbers.getObjects().get(0)).getNumber();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.client().getApiService().powerpackBuyAddNumberCreate(this.client().getAuthId(), this.uuid, this.number, this);
    }
}

