/*
 * Decompiled with CFR 0.152.
 */
package com.plivo.api.models.callfeedback;

import com.plivo.api.models.base.Creator;
import com.plivo.api.models.callfeedback.CallFeedbackCreateResponse;
import com.plivo.api.util.Utils;
import java.util.List;
import retrofit2.Call;

public class CallFeedbackCreator
extends Creator<CallFeedbackCreateResponse> {
    private String callUUID;
    private Float rating;
    private List<String> issues;
    private String notes;

    CallFeedbackCreator(String callUUID, Float rating) {
        if (!Utils.allNotNull(callUUID, rating)) {
            throw new IllegalArgumentException("callUUID or rating cannot be null");
        }
        if (rating.floatValue() < 1.0f && rating.floatValue() > 5.0f) {
            throw new IllegalArgumentException("Rating has to be a float between 1 - 5");
        }
        this.callUUID = callUUID;
        this.rating = rating;
    }

    public CallFeedbackCreator issues(List<String> issues) {
        this.issues = issues;
        return this;
    }

    public CallFeedbackCreator notes(String notes) {
        this.notes = notes;
        return this;
    }

    @Override
    protected Call<CallFeedbackCreateResponse> obtainCall() {
        return this.client().getCallInsightsAPIService().callFeedbackCreate(this.callUUID, this);
    }
}

