/*
 * Decompiled with CFR 0.152.
 */
package com.plivo.api.models.call.actions;

import com.plivo.api.PlivoClient;
import com.plivo.api.exceptions.PlivoRestException;
import com.plivo.api.models.base.VoiceCreator;
import com.plivo.api.models.call.actions.CallRecordCreateResponse;
import java.io.IOException;
import retrofit2.Call;

public class CallRecordCreator
extends VoiceCreator<CallRecordCreateResponse> {
    private final String id;
    private Integer timeLimit;
    private String fileFormat;
    private String transcriptionType;
    private String transcriptionUrl;
    private String transcriptionMethod;
    private String callbackUrl;
    private String callbackMethod;

    public CallRecordCreator(String id) {
        this.id = id;
    }

    @Override
    protected Call<CallRecordCreateResponse> obtainCall() {
        return this.client().getVoiceApiService().callRecordCreate(this.client().getAuthId(), this.id, this);
    }

    @Override
    protected Call<CallRecordCreateResponse> obtainFallback1Call() {
        return this.client().getVoiceFallback1Service().callRecordCreate(this.client().getAuthId(), this.id, this);
    }

    @Override
    protected Call<CallRecordCreateResponse> obtainFallback2Call() {
        return this.client().getVoiceFallback2Service().callRecordCreate(this.client().getAuthId(), this.id, this);
    }

    public CallRecordCreateResponse record() throws IOException, PlivoRestException {
        return (CallRecordCreateResponse)this.create();
    }

    @Override
    public CallRecordCreator client(PlivoClient plivoClient) {
        this.plivoClient = plivoClient;
        return this;
    }

    public CallRecordCreator timeLimit(Integer timeLimit) {
        this.timeLimit = timeLimit;
        return this;
    }

    public CallRecordCreator fileFormat(String fileFormat) {
        this.fileFormat = fileFormat;
        return this;
    }

    public CallRecordCreator transcriptionType(String transcriptionType) {
        this.transcriptionType = transcriptionType;
        return this;
    }

    public CallRecordCreator transcriptionUrl(String transcriptionUrl) {
        this.transcriptionUrl = transcriptionUrl;
        return this;
    }

    public CallRecordCreator transcriptionMethod(String transcriptionMethod) {
        this.transcriptionMethod = transcriptionMethod;
        return this;
    }

    public CallRecordCreator callbackUrl(String callbackUrl) {
        this.callbackUrl = callbackUrl;
        return this;
    }

    public CallRecordCreator callbackMethod(String callbackMethod) {
        this.callbackMethod = callbackMethod;
        return this;
    }

    public Integer timeLimit() {
        return this.timeLimit;
    }

    public String fileFormat() {
        return this.fileFormat;
    }

    public String transcriptionType() {
        return this.transcriptionType;
    }

    public String transcriptionUrl() {
        return this.transcriptionUrl;
    }

    public String transcriptionMethod() {
        return this.transcriptionMethod;
    }

    public String callbackUrl() {
        return this.callbackUrl;
    }

    public String callbackMethod() {
        return this.callbackMethod;
    }
}

