/*
 * Decompiled with CFR 0.152.
 */
package com.plivo.api.models.base;

import com.plivo.api.PlivoClient;
import com.plivo.api.exceptions.PlivoRestException;
import com.plivo.api.exceptions.PlivoValidationException;
import com.plivo.api.models.base.BaseRequest;
import com.plivo.api.models.base.BaseResource;
import java.io.IOException;
import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.Response;

public abstract class VoiceDeleter<T extends BaseResource>
extends BaseRequest<T> {
    protected String id;
    protected String secondaryId;

    public VoiceDeleter(String id) {
        this.id = id;
        if (id == null) {
            throw new IllegalArgumentException("id cannot be null");
        }
    }

    public VoiceDeleter(String id, String secondaryId) {
        if (id == null || secondaryId == null) {
            throw new IllegalArgumentException("id/secondaryId cannot be null");
        }
        this.id = id;
        this.secondaryId = secondaryId;
    }

    public void delete() throws IOException, PlivoRestException, PlivoValidationException {
        this.validate();
        Response response = this.obtainCall().execute();
        if (response.code() >= 500 && (response = this.obtainFallback1Call().execute()).code() >= 500) {
            response = this.obtainFallback2Call().execute();
        }
        this.handleResponse(response);
    }

    @Override
    public VoiceDeleter<T> client(PlivoClient plivoClient) {
        this.plivoClient = plivoClient;
        return this;
    }

    protected abstract Call<ResponseBody> obtainCall() throws PlivoValidationException;

    protected abstract Call<ResponseBody> obtainFallback1Call() throws PlivoValidationException;

    protected abstract Call<ResponseBody> obtainFallback2Call() throws PlivoValidationException;
}

