/*
 * Decompiled with CFR 0.152.
 */
package com.plivo.api.models.base;

import com.plivo.api.PlivoClient;
import com.plivo.api.exceptions.PlivoRestException;
import com.plivo.api.exceptions.PlivoValidationException;
import com.plivo.api.models.base.BaseRequest;
import com.plivo.api.models.base.BaseResource;
import java.io.IOException;
import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.Response;

public abstract class Deleter<T extends BaseResource>
extends BaseRequest<T> {
    protected String id;
    protected String secondaryId;

    public Deleter(String id) {
        this.id = id;
        if (id == null) {
            throw new IllegalArgumentException("id cannot be null");
        }
    }

    public Deleter(String id, String secondaryId) {
        if (id == null || secondaryId == null) {
            throw new IllegalArgumentException("id/secondaryId cannot be null");
        }
        this.id = id;
        this.secondaryId = secondaryId;
    }

    public void delete() throws IOException, PlivoRestException, PlivoValidationException {
        this.validate();
        Response response = this.obtainCall().execute();
        this.handleResponse(response);
    }

    @Override
    public Deleter<T> client(PlivoClient plivoClient) {
        this.plivoClient = plivoClient;
        return this;
    }

    protected abstract Call<ResponseBody> obtainCall() throws PlivoValidationException;
}

