/*
 * Decompiled with CFR 0.152.
 */
package com.plivo.api.models.address;

import com.plivo.api.models.address.AddressCreateResponse;
import com.plivo.api.models.base.Creator;
import com.plivo.api.util.Utils;
import retrofit2.Call;

public class AddressCreator
extends Creator<AddressCreateResponse> {
    private String countryIso;
    private String alias;
    private String salutation;
    private String firstName;
    private String lastName;
    private String addressLine1;
    private String addressLine2;
    private String city;
    private String region;
    private String postalCode;
    private String file;
    private Boolean autoCorrectAddress;
    private String addressProofType;

    public String countryIso() {
        return this.countryIso;
    }

    public String salutation() {
        return this.salutation;
    }

    public String firstName() {
        return this.firstName;
    }

    public String lastName() {
        return this.lastName;
    }

    public String addressLine1() {
        return this.addressLine1;
    }

    public String addressLine2() {
        return this.addressLine2;
    }

    public String city() {
        return this.city;
    }

    public String region() {
        return this.region;
    }

    public String postalCode() {
        return this.postalCode;
    }

    public String file() {
        return this.file;
    }

    public Boolean autoCorrectAddress() {
        return this.autoCorrectAddress;
    }

    public String addressProofType() {
        return this.addressProofType;
    }

    public AddressCreator(String countryIso, String salutation, String firstName, String lastName, String addressLine1, String addressLine2, String city, String region, String postalCode) {
        if (!Utils.allNotNull(countryIso, salutation, firstName, lastName, addressLine1, addressLine2, city, region, postalCode)) {
            throw new IllegalArgumentException("countryIso, salutation, firstName, lastName,addressLine1, addressLine2, city, region and postalCode must not be null");
        }
        this.countryIso = countryIso;
        this.salutation = salutation;
        this.firstName = firstName;
        this.lastName = lastName;
        this.addressLine1 = addressLine1;
        this.addressLine2 = addressLine2;
        this.city = city;
        this.region = region;
        this.postalCode = postalCode;
    }

    public AddressCreator countryIso(String countryIso) {
        this.countryIso = countryIso;
        return this;
    }

    public AddressCreator alias(String alias) {
        this.alias = alias;
        return this;
    }

    public AddressCreator salutation(String salutation) {
        this.salutation = salutation;
        return this;
    }

    public AddressCreator firstName(String firstName) {
        this.firstName = firstName;
        return this;
    }

    public AddressCreator lastName(String lastName) {
        this.lastName = lastName;
        return this;
    }

    public AddressCreator addressLine1(String addressLine1) {
        this.addressLine1 = addressLine1;
        return this;
    }

    public AddressCreator addressLine2(String addressLine2) {
        this.addressLine2 = addressLine2;
        return this;
    }

    public AddressCreator city(String city) {
        this.city = city;
        return this;
    }

    public AddressCreator region(String region) {
        this.region = region;
        return this;
    }

    public AddressCreator postalCode(String postalCode) {
        this.postalCode = postalCode;
        return this;
    }

    public AddressCreator file(String file) {
        this.file = file;
        return this;
    }

    public AddressCreator autoCorrectAddress(Boolean autoCorrectAddress) {
        this.autoCorrectAddress = autoCorrectAddress;
        return this;
    }

    public AddressCreator addressProofType(String addressProofType) {
        this.addressProofType = addressProofType;
        return this;
    }

    @Override
    protected Call<AddressCreateResponse> obtainCall() {
        return this.client().getApiService().addressCreate(this.client().getAuthId(), this);
    }
}

