/*
 * Decompiled with CFR 0.152.
 */
package com.plivo.api.models.call;

import com.plivo.api.exceptions.PlivoRestException;
import com.plivo.api.models.base.Updater;
import com.plivo.api.models.call.CallUpdateResponse;
import com.plivo.api.models.call.LegSpecifier;
import com.plivo.api.util.Utils;
import java.io.IOException;
import retrofit2.Call;

public class CallUpdater
extends Updater<CallUpdateResponse> {
    LegSpecifier legs;
    String alegUrl;
    String alegMethod;
    String blegUrl;
    String blegMethod;

    public CallUpdater(String id) {
        super(id);
    }

    public LegSpecifier legs() {
        return this.legs;
    }

    public String alegUrl() {
        return this.alegUrl;
    }

    public String alegMethod() {
        return this.alegMethod;
    }

    public String blegUrl() {
        return this.blegUrl;
    }

    public String blegMethod() {
        return this.blegMethod;
    }

    public CallUpdater legs(LegSpecifier legs) {
        this.legs = legs;
        return this;
    }

    public CallUpdater alegUrl(String alegUrl) {
        this.alegUrl = alegUrl;
        return this;
    }

    public CallUpdater alegMethod(String alegMethod) {
        this.alegMethod = alegMethod;
        return this;
    }

    public CallUpdater blegUrl(String blegUrl) {
        this.blegUrl = blegUrl;
        return this;
    }

    public CallUpdater blegMethod(String blegMethod) {
        this.blegMethod = blegMethod;
        return this;
    }

    @Override
    protected void validate() {
        super.validate();
        if (!Utils.anyNotNull(new Object[]{this.alegMethod, this.alegUrl, this.blegMethod, this.blegUrl, this.legs})) {
            throw new IllegalStateException("at least one param should be non null");
        }
    }

    @Override
    protected Call<CallUpdateResponse> obtainCall() {
        return this.client().getApiService().callUpdate(this.client().getAuthId(), this.id, this);
    }

    public CallUpdateResponse transfer() throws IOException, PlivoRestException {
        return (CallUpdateResponse)this.update();
    }
}

