/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.test.common.utils;

import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoField;
import org.springframework.util.StringUtils;

public class DateUtils {
    public static String toDateAndTimeAgo(String isoFormattedDate) {
        Object instantOrString = DateUtils.parseToInstantOrString(isoFormattedDate);
        if (!(instantOrString instanceof Instant)) {
            return (String)instantOrString;
        }
        Instant instant = (Instant)instantOrString;
        OffsetDateTime offsetDateTime = ((Instant)instantOrString).atZone(ZoneId.systemDefault()).toOffsetDateTime();
        return offsetDateTime + " (" + DateUtils.toTimeAgo(instant.toEpochMilli()) + ")";
    }

    public static String toTimeAgo(String isoFormattedDate) {
        Object instantOrString = DateUtils.parseToInstantOrString(isoFormattedDate);
        return instantOrString instanceof Instant ? DateUtils.toTimeAgo(((Instant)instantOrString).toEpochMilli()) : (String)instantOrString;
    }

    static Object parseToInstantOrString(String isoFormattedDate) {
        if (isoFormattedDate == null) {
            return null;
        }
        if (!StringUtils.hasText((String)isoFormattedDate)) {
            return "";
        }
        try {
            return Instant.from(DateTimeFormatter.ISO_OFFSET_DATE_TIME.parse(isoFormattedDate)).with(ChronoField.NANO_OF_SECOND, 0L);
        }
        catch (DateTimeParseException e) {
            return e.getMessage();
        }
    }

    public static String toTimeAgo(long epochMillis) {
        long seconds = Instant.now().toEpochMilli() / 1000L - epochMillis / 1000L;
        long minutes = Math.round((double)seconds / 60.0);
        if (minutes <= 50L) {
            return minutes <= 1L ? "a minute ago" : minutes + " minutes ago";
        }
        long hours = Math.round((double)seconds / 3600.0);
        if (hours <= 20L) {
            return hours == 1L ? "an hour ago" : hours + " hours ago";
        }
        long days = Math.round((double)seconds / 86400.0);
        if (days <= 5L) {
            return days <= 1L ? "yesterday" : days + " days ago";
        }
        long weeks = Math.round((double)seconds / 604800.0);
        if (weeks <= 3L) {
            return weeks <= 1L ? "a week ago" : weeks + " weeks ago";
        }
        long months = Math.round((double)seconds / 2628288.0);
        if (months <= 10L) {
            return months <= 1L ? "a month ago" : months + " months ago";
        }
        long years = months / 12L;
        return (months %= 12L) <= 1L || years == 0L ? (years <= 1L ? "a year" : years + " years") + " ago" : years + (years <= 1L ? " year " : " years ") + months + " months ago";
    }
}

