/*
 * Decompiled with CFR 0.152.
 */
package reactivefeign.webclient.client5;

import java.util.concurrent.TimeoutException;
import java.util.function.BiFunction;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientRequestException;
import reactivefeign.ReactiveOptions;
import reactivefeign.client.ReactiveHttpRequest;
import reactivefeign.client.ReadTimeoutException;
import reactivefeign.webclient.CoreWebBuilder;
import reactivefeign.webclient.WebClientFeignCustomizer;
import reactivefeign.webclient.client5.HttpClient5HttpConnectorBuilder;
import reactivefeign.webclient.client5.HttpClient5ReactiveOptions;

public class HttpClient5WebReactiveFeign {
    public static <T> Builder<T> builder() {
        return HttpClient5WebReactiveFeign.builder(WebClient.builder());
    }

    public static <T> Builder<T> builder(WebClient.Builder webClientBuilder) {
        return new Builder(webClientBuilder);
    }

    public static <T> Builder<T> builder(WebClient.Builder webClientBuilder, WebClientFeignCustomizer webClientCustomizer) {
        return new Builder(webClientBuilder, webClientCustomizer);
    }

    public static class Builder<T>
    extends CoreWebBuilder<T> {
        private HttpClient5ReactiveOptions reactiveOptions;

        protected Builder(WebClient.Builder webClientBuilder) {
            super(webClientBuilder);
        }

        protected Builder(WebClient.Builder webClientBuilder, WebClientFeignCustomizer webClientCustomizer) {
            super(webClientBuilder, webClientCustomizer);
        }

        public Builder<T> options(ReactiveOptions options) {
            this.reactiveOptions = (HttpClient5ReactiveOptions)options;
            return this;
        }

        public BiFunction<ReactiveHttpRequest, Throwable, Throwable> errorMapper() {
            return (request, throwable) -> {
                if (throwable instanceof WebClientRequestException && throwable.getCause() instanceof TimeoutException) {
                    return new ReadTimeoutException(throwable, request);
                }
                return null;
            };
        }

        protected ClientHttpConnector clientConnector() {
            return HttpClient5HttpConnectorBuilder.buildHttp5ClientHttpConnector(this.reactiveOptions);
        }
    }
}

