/*
 * Decompiled with CFR 0.152.
 */
package reactivefeign.java11;

import com.fasterxml.jackson.core.async_.JsonFactory;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.net.http.HttpClient;
import java.time.Duration;
import reactivefeign.ReactiveFeign;
import reactivefeign.ReactiveOptions;
import reactivefeign.java11.Java11ReactiveOptions;
import reactivefeign.java11.client.Java11ReactiveHttpClientFactory;

public final class Java11ReactiveFeign {
    private Java11ReactiveFeign() {
    }

    public static <T> Builder<T> builder() {
        try {
            return Java11ReactiveFeign.builder(HttpClient.newBuilder());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> Builder<T> builder(HttpClient.Builder httpClientBuilder) {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule((Module)new JavaTimeModule());
        return Java11ReactiveFeign.builder(httpClientBuilder, new JsonFactory(), objectMapper);
    }

    public static <T> Builder<T> builder(HttpClient.Builder httpClientBuilder, JsonFactory jsonFactory, ObjectMapper objectMapper) {
        return new Builder(httpClientBuilder, jsonFactory, objectMapper);
    }

    public static class Builder<T>
    extends ReactiveFeign.Builder<T> {
        protected HttpClient.Builder httpClientBuilder;
        protected JsonFactory jsonFactory;
        private ObjectMapper objectMapper;
        protected Java11ReactiveOptions options;
        protected HttpClient.Version version = HttpClient.Version.HTTP_1_1;

        protected Builder(HttpClient.Builder httpClientBuilder, JsonFactory jsonFactory, ObjectMapper objectMapper) {
            this.setHttpClient(httpClientBuilder, jsonFactory, objectMapper);
            this.jsonFactory = jsonFactory;
            this.objectMapper = objectMapper;
        }

        public Builder<T> version(HttpClient.Version version) {
            this.version = version;
            return this;
        }

        public Builder<T> options(ReactiveOptions options) {
            this.options = (Java11ReactiveOptions)options;
            if (this.options.getConnectTimeoutMillis() != null) {
                this.httpClientBuilder = this.httpClientBuilder.connectTimeout(Duration.ofMillis(options.getConnectTimeoutMillis()));
            }
            this.setHttpClient(this.httpClientBuilder, this.jsonFactory, this.objectMapper);
            return this;
        }

        protected void setHttpClient(HttpClient.Builder httpClientBuilder, JsonFactory jsonFactory, ObjectMapper objectMapper) {
            this.httpClientBuilder = httpClientBuilder;
            HttpClient httpClient = httpClientBuilder.build();
            this.clientFactory(new Java11ReactiveHttpClientFactory(httpClient, jsonFactory, objectMapper, this.options, this.version));
        }
    }
}

